/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import java.util.Arrays;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.events.FilterType;
import org.apache.commons.math3.ode.events.Transformer;

public class EventFilter
implements EventHandler {
    private static final int HISTORY_SIZE = 100;
    private final EventHandler rawHandler;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final double[] updates;
    private boolean forward;
    private double extremeT;

    public EventFilter(EventHandler eventHandler, FilterType filterType) {
        this.rawHandler = eventHandler;
        this.filter = filterType;
        this.transformers = new Transformer[100];
        this.updates = new double[100];
    }

    public void init(double d, double[] dArray, double d2) {
        this.rawHandler.init(d, dArray, d2);
        this.forward = d2 >= d;
        this.extremeT = this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    public double g(double d, double[] dArray) {
        double d2 = this.rawHandler.g(d, dArray);
        if (this.forward) {
            int n = this.transformers.length - 1;
            if (this.extremeT < d) {
                Transformer transformer = this.transformers[n];
                Transformer transformer2 = this.filter.selectTransformer(transformer, d2, this.forward);
                if (transformer2 != transformer) {
                    System.arraycopy(this.updates, 1, this.updates, 0, n);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, n);
                    this.updates[n] = this.extremeT;
                    this.transformers[n] = transformer2;
                }
                this.extremeT = d;
                return transformer2.transformed(d2);
            }
            for (int i = n; i > 0; --i) {
                if (!(this.updates[i] <= d)) continue;
                return this.transformers[i].transformed(d2);
            }
            return this.transformers[0].transformed(d2);
        }
        if (d < this.extremeT) {
            Transformer transformer = this.transformers[0];
            Transformer transformer3 = this.filter.selectTransformer(transformer, d2, this.forward);
            if (transformer3 != transformer) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = transformer3;
            }
            this.extremeT = d;
            return transformer3.transformed(d2);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (!(d <= this.updates[i])) continue;
            return this.transformers[i].transformed(d2);
        }
        return this.transformers[this.updates.length - 1].transformed(d2);
    }

    public EventHandler.Action eventOccurred(double d, double[] dArray, boolean bl) {
        return this.rawHandler.eventOccurred(d, dArray, this.filter.getTriggeredIncreasing());
    }

    public void resetState(double d, double[] dArray) {
        this.rawHandler.resetState(d, dArray);
    }
}

