/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.ode.events.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FilterType {
    TRIGGER_ONLY_DECREASING_EVENTS{

        protected boolean getTriggeredIncreasing() {
            return false;
        }

        protected Transformer selectTransformer(Transformer transformer, double d, boolean bl) {
            if (bl) {
                switch (transformer) {
                    case UNINITIALIZED: {
                        if (d > 0.0) {
                            return Transformer.MAX;
                        }
                        if (d < 0.0) {
                            return Transformer.PLUS;
                        }
                        return Transformer.UNINITIALIZED;
                    }
                    case PLUS: {
                        if (d >= 0.0) {
                            return Transformer.MIN;
                        }
                        return transformer;
                    }
                    case MINUS: {
                        if (d >= 0.0) {
                            return Transformer.MAX;
                        }
                        return transformer;
                    }
                    case MIN: {
                        if (d <= 0.0) {
                            return Transformer.MINUS;
                        }
                        return transformer;
                    }
                    case MAX: {
                        if (d <= 0.0) {
                            return Transformer.PLUS;
                        }
                        return transformer;
                    }
                }
                throw new MathInternalError();
            }
            switch (transformer) {
                case UNINITIALIZED: {
                    if (d > 0.0) {
                        return Transformer.MINUS;
                    }
                    if (d < 0.0) {
                        return Transformer.MIN;
                    }
                    return Transformer.UNINITIALIZED;
                }
                case PLUS: {
                    if (d <= 0.0) {
                        return Transformer.MAX;
                    }
                    return transformer;
                }
                case MINUS: {
                    if (d <= 0.0) {
                        return Transformer.MIN;
                    }
                    return transformer;
                }
                case MIN: {
                    if (d >= 0.0) {
                        return Transformer.PLUS;
                    }
                    return transformer;
                }
                case MAX: {
                    if (d >= 0.0) {
                        return Transformer.MINUS;
                    }
                    return transformer;
                }
            }
            throw new MathInternalError();
        }
    }
    ,
    TRIGGER_ONLY_INCREASING_EVENTS{

        protected boolean getTriggeredIncreasing() {
            return true;
        }

        protected Transformer selectTransformer(Transformer transformer, double d, boolean bl) {
            if (bl) {
                switch (transformer) {
                    case UNINITIALIZED: {
                        if (d > 0.0) {
                            return Transformer.PLUS;
                        }
                        if (d < 0.0) {
                            return Transformer.MIN;
                        }
                        return Transformer.UNINITIALIZED;
                    }
                    case PLUS: {
                        if (d <= 0.0) {
                            return Transformer.MAX;
                        }
                        return transformer;
                    }
                    case MINUS: {
                        if (d <= 0.0) {
                            return Transformer.MIN;
                        }
                        return transformer;
                    }
                    case MIN: {
                        if (d >= 0.0) {
                            return Transformer.PLUS;
                        }
                        return transformer;
                    }
                    case MAX: {
                        if (d >= 0.0) {
                            return Transformer.MINUS;
                        }
                        return transformer;
                    }
                }
                throw new MathInternalError();
            }
            switch (transformer) {
                case UNINITIALIZED: {
                    if (d > 0.0) {
                        return Transformer.MAX;
                    }
                    if (d < 0.0) {
                        return Transformer.MINUS;
                    }
                    return Transformer.UNINITIALIZED;
                }
                case PLUS: {
                    if (d >= 0.0) {
                        return Transformer.MIN;
                    }
                    return transformer;
                }
                case MINUS: {
                    if (d >= 0.0) {
                        return Transformer.MAX;
                    }
                    return transformer;
                }
                case MIN: {
                    if (d <= 0.0) {
                        return Transformer.MINUS;
                    }
                    return transformer;
                }
                case MAX: {
                    if (d <= 0.0) {
                        return Transformer.PLUS;
                    }
                    return transformer;
                }
            }
            throw new MathInternalError();
        }
    };


    protected abstract boolean getTriggeredIncreasing();

    protected abstract Transformer selectTransformer(Transformer var1, double var2, boolean var4);
}

