/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.nonstiff.AdamsIntegrator;
import org.apache.commons.math3.ode.sampling.NordsieckStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class AdamsBashforthIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthIntegrator(int n, double d, double d2, double d3, double d4) {
        super(METHOD_NAME, n, n, d, d2, d3, d4);
    }

    public AdamsBashforthIntegrator(int n, double d, double d2, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, n, n, d, d2, dArray, dArray2);
    }

    private double errorEstimation(double[] dArray, double[] dArray2, double[] dArray3, RealMatrix realMatrix) {
        double d = 0.0;
        for (int i = 0; i < this.mainSetDimension; ++i) {
            double d2 = FastMath.abs(dArray2[i]);
            double d3 = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * d2 : this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * d2;
            double d4 = 0.0;
            int n = realMatrix.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int j = realMatrix.getRowDimension() - 1; j >= 0; --j) {
                d4 += (double)n * realMatrix.getEntry(j, i);
                n = -n;
            }
            double d5 = (dArray2[i] - dArray[i] + (d4 -= dArray3[i])) / d3;
            d += d5 * d5;
        }
        return FastMath.sqrt(d / (double)this.mainSetDimension);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d) {
        this.sanityChecks(expandableStatefulODE, d);
        this.setEquations(expandableStatefulODE);
        boolean bl = d > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = new double[dArray.length];
        NordsieckStepInterpolator nordsieckStepInterpolator = new NordsieckStepInterpolator();
        nordsieckStepInterpolator.reinitialize(dArray, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d);
        this.start(expandableStatefulODE.getTime(), dArray, d);
        nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
        nordsieckStepInterpolator.storeTime(this.stepStart);
        double d2 = this.stepSize;
        nordsieckStepInterpolator.rescale(d2);
        this.isLastStep = false;
        do {
            boolean bl2;
            double d3;
            nordsieckStepInterpolator.shift();
            double[] dArray3 = new double[dArray.length];
            double[] dArray4 = new double[dArray.length];
            Array2DRowRealMatrix array2DRowRealMatrix = null;
            double d4 = 10.0;
            while (d4 >= 1.0) {
                d3 = this.stepStart + d2;
                nordsieckStepInterpolator.storeTime(d3);
                ExpandableStatefulODE expandableStatefulODE2 = this.getExpandable();
                EquationsMapper equationsMapper = expandableStatefulODE2.getPrimaryMapper();
                equationsMapper.insertEquationData(nordsieckStepInterpolator.getInterpolatedState(), dArray3);
                int n = 0;
                for (EquationsMapper equationsMapper2 : expandableStatefulODE2.getSecondaryMappers()) {
                    equationsMapper2.insertEquationData(nordsieckStepInterpolator.getInterpolatedSecondaryState(n), dArray3);
                    ++n;
                }
                this.computeDerivatives(d3, dArray3, dArray2);
                for (int i = 0; i < dArray4.length; ++i) {
                    dArray4[i] = d2 * dArray2[i];
                }
                array2DRowRealMatrix = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, dArray4, array2DRowRealMatrix);
                d4 = this.errorEstimation(dArray, dArray3, dArray4, array2DRowRealMatrix);
                if (!(d4 >= 1.0)) continue;
                double d5 = this.computeStepGrowShrinkFactor(d4);
                d2 = this.filterStep(d2 * d5, bl, false);
                nordsieckStepInterpolator.rescale(d2);
            }
            this.stepSize = d2;
            d3 = this.stepStart + this.stepSize;
            nordsieckStepInterpolator.reinitialize(d3, this.stepSize, dArray4, array2DRowRealMatrix);
            nordsieckStepInterpolator.storeTime(d3);
            System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
            this.stepStart = this.acceptStep(nordsieckStepInterpolator, dArray, dArray2, d);
            this.scaled = dArray4;
            this.nordsieck = array2DRowRealMatrix;
            nordsieckStepInterpolator.reinitialize(d3, this.stepSize, this.scaled, this.nordsieck);
            if (this.isLastStep) continue;
            nordsieckStepInterpolator.storeTime(this.stepStart);
            if (this.resetOccurred) {
                this.start(this.stepStart, dArray, d);
                nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
            }
            double d6 = this.computeStepGrowShrinkFactor(d4);
            double d7 = this.stepSize * d6;
            double d8 = this.stepStart + d7;
            boolean bl3 = bl ? d8 >= d : d8 <= d;
            d2 = this.filterStep(d7, bl, bl3);
            double d9 = this.stepStart + d2;
            boolean bl4 = bl ? d9 >= d : (bl2 = d9 <= d);
            if (bl2) {
                d2 = d - this.stepStart;
            }
            nordsieckStepInterpolator.rescale(d2);
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray);
        this.resetInternalState();
    }
}

