/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.sampling.AbstractFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdamsFieldStepInterpolator<T extends RealFieldElement<T>>
extends AbstractFieldStepInterpolator<T> {
    private T scalingH;
    private final FieldODEStateAndDerivative<T> reference;
    private final T[] scaled;
    private final Array2DRowFieldMatrix<T> nordsieck;

    AdamsFieldStepInterpolator(T t, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T[] TArray, Array2DRowFieldMatrix<T> array2DRowFieldMatrix, boolean bl, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldEquationsMapper<T> fieldEquationsMapper) {
        this((RealFieldElement)t, fieldODEStateAndDerivative, (RealFieldElement[])TArray, array2DRowFieldMatrix, bl, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldEquationsMapper);
    }

    private AdamsFieldStepInterpolator(T t, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T[] TArray, Array2DRowFieldMatrix<T> array2DRowFieldMatrix, boolean bl, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative5, FieldEquationsMapper<T> fieldEquationsMapper) {
        super(bl, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldODEStateAndDerivative5, fieldEquationsMapper);
        this.scalingH = t;
        this.reference = fieldODEStateAndDerivative;
        this.scaled = (RealFieldElement[])TArray.clone();
        this.nordsieck = new Array2DRowFieldMatrix(array2DRowFieldMatrix.getData(), false);
    }

    @Override
    protected AdamsFieldStepInterpolator<T> create(boolean bl, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new AdamsFieldStepInterpolator(this.scalingH, this.reference, this.scaled, this.nordsieck, bl, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> fieldEquationsMapper, T t, T t2, T t3, T t4) {
        return AdamsFieldStepInterpolator.taylor(this.reference, t, this.scalingH, this.scaled, this.nordsieck);
    }

    public static <S extends RealFieldElement<S>> FieldODEStateAndDerivative<S> taylor(FieldODEStateAndDerivative<S> fieldODEStateAndDerivative, S s, S s2, S[] SArray, Array2DRowFieldMatrix<S> array2DRowFieldMatrix) {
        int n;
        RealFieldElement realFieldElement = (RealFieldElement)s.subtract(fieldODEStateAndDerivative.getTime());
        S s3 = realFieldElement.divide(s2);
        Object[] objectArray = (RealFieldElement[])MathArrays.buildArray(s.getField(), SArray.length);
        Arrays.fill(objectArray, s.getField().getZero());
        Object[] objectArray2 = (RealFieldElement[])MathArrays.buildArray(s.getField(), SArray.length);
        Arrays.fill(objectArray2, s.getField().getZero());
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])array2DRowFieldMatrix.getDataRef();
        for (int i = realFieldElementArray.length - 1; i >= 0; --i) {
            n = i + 2;
            RealFieldElement[] realFieldElementArray2 = realFieldElementArray[i];
            RealFieldElement realFieldElement2 = (RealFieldElement)s3.pow((int)n);
            for (int j = 0; j < realFieldElementArray2.length; ++j) {
                RealFieldElement realFieldElement3 = realFieldElementArray2[j].multiply(realFieldElement2);
                objectArray[j] = objectArray[j].add(realFieldElement3);
                objectArray2[j] = (RealFieldElement)objectArray2[j].add(realFieldElement3.multiply(n));
            }
        }
        RealFieldElement[] realFieldElementArray3 = fieldODEStateAndDerivative.getState();
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = objectArray[n].add(SArray[n].multiply(s3));
            realFieldElementArray3[n] = (RealFieldElement)realFieldElementArray3[n].add(objectArray[n]);
            objectArray2[n] = objectArray2[n].add(SArray[n].multiply(s3)).divide((RealFieldElement)realFieldElement);
        }
        return new FieldODEStateAndDerivative(s, realFieldElementArray3, (RealFieldElement[])objectArray2);
    }
}

