/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdamsFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsMoultonFieldIntegrator<T extends RealFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonFieldIntegrator(Field<T> field, int n, double d, double d2, double d3, double d4) {
        super(field, METHOD_NAME, n, n + 1, d, d2, d3, d4);
    }

    public AdamsMoultonFieldIntegrator(Field<T> field, int n, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, n, n + 1, d, d2, dArray, dArray2);
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        this.setStepStart(this.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        this.start(fieldExpandableODE, this.getStepStart(), t);
        FieldODEStateAndDerivative fieldODEStateAndDerivative = this.getStepStart();
        FieldODEStateAndDerivative fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(fieldODEStateAndDerivative, (RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative.getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        this.setIsLastStep(false);
        do {
            boolean bl2;
            RealFieldElement[] realFieldElementArray2;
            object = null;
            RealFieldElement[] realFieldElementArray3 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            Array2DRowFieldMatrix array2DRowFieldMatrix = null;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0) {
                object = fieldODEStateAndDerivative2.getState();
                realFieldElementArray2 = this.computeDerivatives((RealFieldElement)fieldODEStateAndDerivative2.getTime(), (RealFieldElement[])object);
                for (int i = 0; i < realFieldElementArray3.length; ++i) {
                    realFieldElementArray3[i] = this.getStepSize().multiply((RealFieldElement)realFieldElementArray2[i]);
                }
                array2DRowFieldMatrix = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, realFieldElementArray3, array2DRowFieldMatrix);
                realFieldElement = (RealFieldElement)array2DRowFieldMatrix.walkInOptimizedOrder(new Corrector(this, realFieldElementArray, realFieldElementArray3, object));
                if (!(((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement2 = this.computeStepGrowShrinkFactor(realFieldElement);
                this.rescale(this.filterStep(this.getStepSize().multiply((RealFieldElement)realFieldElement2), bl, false));
                fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
            }
            realFieldElementArray2 = this.computeDerivatives((RealFieldElement)fieldODEStateAndDerivative2.getTime(), (RealFieldElement[])object);
            RealFieldElement[] realFieldElementArray4 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            for (int i = 0; i < realFieldElementArray4.length; ++i) {
                realFieldElementArray4[i] = this.getStepSize().multiply((RealFieldElement)realFieldElementArray2[i]);
            }
            this.updateHighOrderDerivativesPhase2(realFieldElementArray3, realFieldElementArray4, array2DRowFieldMatrix);
            fieldODEStateAndDerivative2 = new FieldODEStateAndDerivative(fieldODEStateAndDerivative2.getTime(), object, realFieldElementArray2);
            this.setStepStart(this.acceptStep(new AdamsFieldStepInterpolator(this.getStepSize(), fieldODEStateAndDerivative2, realFieldElementArray4, array2DRowFieldMatrix, bl, this.getStepStart(), fieldODEStateAndDerivative2, fieldExpandableODE.getMapper()), t));
            this.scaled = realFieldElementArray4;
            this.nordsieck = array2DRowFieldMatrix;
            if (this.isLastStep()) continue;
            System.arraycopy(object, 0, realFieldElementArray, 0, realFieldElementArray.length);
            if (this.resetOccurred()) {
                this.start(fieldExpandableODE, this.getStepStart(), t);
            }
            RealFieldElement realFieldElement3 = this.computeStepGrowShrinkFactor(realFieldElement);
            RealFieldElement realFieldElement4 = this.getStepSize().multiply((RealFieldElement)realFieldElement3);
            RealFieldElement realFieldElement5 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement4);
            boolean bl3 = bl ? ((RealFieldElement)realFieldElement5.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)realFieldElement5.subtract(t)).getReal() <= 0.0;
            RealFieldElement realFieldElement6 = this.filterStep(realFieldElement4, bl, bl3);
            RealFieldElement realFieldElement7 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement6);
            boolean bl4 = bl ? ((RealFieldElement)realFieldElement7.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)realFieldElement7.subtract(t)).getReal() <= 0.0);
            if (bl2) {
                realFieldElement6 = (RealFieldElement)t.subtract(this.getStepStart().getTime());
            }
            this.rescale(realFieldElement6);
            fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Corrector
    implements FieldMatrixPreservingVisitor<T> {
        private final T[] previous;
        private final T[] scaled;
        private final T[] before;
        private final T[] after;
        final /* synthetic */ AdamsMoultonFieldIntegrator this$0;

        Corrector(T[] TArray, T[] TArray2, T[] TArray3) {
            this.this$0 = var1_1;
            this.previous = TArray;
            this.scaled = TArray2;
            this.after = TArray3;
            this.before = (RealFieldElement[])TArray3.clone();
        }

        @Override
        public void start(int n, int n2, int n3, int n4, int n5, int n6) {
            Arrays.fill(this.after, this.this$0.getField().getZero());
        }

        @Override
        public void visit(int n, int n2, T t) {
            this.after[n2] = (n & 1) == 0 ? (RealFieldElement)this.after[n2].subtract(t) : (RealFieldElement)this.after[n2].add(t);
        }

        @Override
        public T end() {
            RealFieldElement realFieldElement = (RealFieldElement)this.this$0.getField().getZero();
            for (int i = 0; i < this.after.length; ++i) {
                this.after[i] = (RealFieldElement)this.after[i].add(this.previous[i].add(this.scaled[i]));
                if (i >= this.this$0.mainSetDimension) continue;
                RealFieldElement realFieldElement2 = MathUtils.max((RealFieldElement)this.previous[i].abs(), (RealFieldElement)this.after[i].abs());
                RealFieldElement realFieldElement3 = this.this$0.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement2.multiply(this.this$0.scalRelativeTolerance)).add(this.this$0.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement2.multiply(this.this$0.vecRelativeTolerance[i])).add(this.this$0.vecAbsoluteTolerance[i]);
                RealFieldElement realFieldElement4 = ((RealFieldElement)this.after[i].subtract(this.before[i])).divide(realFieldElement3);
                realFieldElement = realFieldElement.add(realFieldElement4.multiply(realFieldElement4));
            }
            return (RealFieldElement)((RealFieldElement)realFieldElement.divide(this.this$0.mainSetDimension)).sqrt();
        }
    }
}

