/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.nonstiff.AdamsIntegrator;
import org.apache.commons.math3.ode.sampling.NordsieckStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class AdamsMoultonIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonIntegrator(int n, double d, double d2, double d3, double d4) {
        super(METHOD_NAME, n, n + 1, d, d2, d3, d4);
    }

    public AdamsMoultonIntegrator(int n, double d, double d2, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, n, n + 1, d, d2, dArray, dArray2);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d) {
        this.sanityChecks(expandableStatefulODE, d);
        this.setEquations(expandableStatefulODE);
        boolean bl = d > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[] dArray5 = new double[dArray2.length];
        Array2DRowRealMatrix array2DRowRealMatrix = null;
        NordsieckStepInterpolator nordsieckStepInterpolator = new NordsieckStepInterpolator();
        nordsieckStepInterpolator.reinitialize(dArray2, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d);
        this.start(expandableStatefulODE.getTime(), dArray2, d);
        nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
        nordsieckStepInterpolator.storeTime(this.stepStart);
        double d2 = this.stepSize;
        nordsieckStepInterpolator.rescale(d2);
        this.isLastStep = false;
        do {
            boolean bl2;
            Object object;
            double d3;
            double d4 = 10.0;
            while (d4 >= 1.0) {
                this.stepSize = d2;
                d3 = this.stepStart + this.stepSize;
                nordsieckStepInterpolator.setInterpolatedTime(d3);
                object = this.getExpandable();
                EquationsMapper equationsMapper = ((ExpandableStatefulODE)object).getPrimaryMapper();
                equationsMapper.insertEquationData(nordsieckStepInterpolator.getInterpolatedState(), dArray4);
                int n = 0;
                for (EquationsMapper equationsMapper2 : ((ExpandableStatefulODE)object).getSecondaryMappers()) {
                    equationsMapper2.insertEquationData(nordsieckStepInterpolator.getInterpolatedSecondaryState(n), dArray4);
                    ++n;
                }
                this.computeDerivatives(d3, dArray4, dArray3);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray5[i] = this.stepSize * dArray3[i];
                }
                array2DRowRealMatrix = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, dArray5, array2DRowRealMatrix);
                d4 = array2DRowRealMatrix.walkInOptimizedOrder(new Corrector(dArray2, dArray5, dArray4));
                if (!(d4 >= 1.0)) continue;
                double d5 = this.computeStepGrowShrinkFactor(d4);
                d2 = this.filterStep(this.stepSize * d5, bl, false);
                nordsieckStepInterpolator.rescale(d2);
            }
            d3 = this.stepStart + this.stepSize;
            this.computeDerivatives(d3, dArray4, dArray3);
            object = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                object[i] = this.stepSize * dArray3[i];
            }
            this.updateHighOrderDerivativesPhase2(dArray5, (double[])object, array2DRowRealMatrix);
            System.arraycopy(dArray4, 0, dArray2, 0, dArray2.length);
            nordsieckStepInterpolator.reinitialize(d3, this.stepSize, (double[])object, array2DRowRealMatrix);
            nordsieckStepInterpolator.storeTime(this.stepStart);
            nordsieckStepInterpolator.shift();
            nordsieckStepInterpolator.storeTime(d3);
            this.stepStart = this.acceptStep(nordsieckStepInterpolator, dArray2, dArray3, d);
            this.scaled = (double[])object;
            this.nordsieck = array2DRowRealMatrix;
            if (this.isLastStep) continue;
            nordsieckStepInterpolator.storeTime(this.stepStart);
            if (this.resetOccurred) {
                this.start(this.stepStart, dArray2, d);
                nordsieckStepInterpolator.reinitialize(this.stepStart, this.stepSize, this.scaled, this.nordsieck);
            }
            double d6 = this.computeStepGrowShrinkFactor(d4);
            double d7 = this.stepSize * d6;
            double d8 = this.stepStart + d7;
            boolean bl3 = bl ? d8 >= d : d8 <= d;
            d2 = this.filterStep(d7, bl, bl3);
            double d9 = this.stepStart + d2;
            boolean bl4 = bl ? d9 >= d : (bl2 = d9 <= d);
            if (bl2) {
                d2 = d - this.stepStart;
            }
            nordsieckStepInterpolator.rescale(d2);
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.resetInternalState();
    }

    private class Corrector
    implements RealMatrixPreservingVisitor {
        private final double[] previous;
        private final double[] scaled;
        private final double[] before;
        private final double[] after;

        Corrector(double[] dArray, double[] dArray2, double[] dArray3) {
            this.previous = dArray;
            this.scaled = dArray2;
            this.after = dArray3;
            this.before = (double[])dArray3.clone();
        }

        public void start(int n, int n2, int n3, int n4, int n5, int n6) {
            Arrays.fill(this.after, 0.0);
        }

        public void visit(int n, int n2, double d) {
            if ((n & 1) == 0) {
                int n3 = n2;
                this.after[n3] = this.after[n3] - d;
            } else {
                int n4 = n2;
                this.after[n4] = this.after[n4] + d;
            }
        }

        public double end() {
            double d = 0.0;
            for (int i = 0; i < this.after.length; ++i) {
                int n = i;
                this.after[n] = this.after[n] + (this.previous[i] + this.scaled[i]);
                if (i >= AdamsMoultonIntegrator.this.mainSetDimension) continue;
                double d2 = FastMath.max(FastMath.abs(this.previous[i]), FastMath.abs(this.after[i]));
                double d3 = AdamsMoultonIntegrator.this.vecAbsoluteTolerance == null ? AdamsMoultonIntegrator.this.scalAbsoluteTolerance + AdamsMoultonIntegrator.this.scalRelativeTolerance * d2 : AdamsMoultonIntegrator.this.vecAbsoluteTolerance[i] + AdamsMoultonIntegrator.this.vecRelativeTolerance[i] * d2;
                double d4 = (this.after[i] - this.before[i]) / d3;
                d += d4 * d4;
            }
            return FastMath.sqrt(d / (double)AdamsMoultonIntegrator.this.mainSetDimension);
        }
    }
}

