/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.util.FastMath;

public abstract class AdaptiveStepsizeIntegrator
extends AbstractIntegrator {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private double initialStep;
    private double minStep;
    private double maxStep;

    public AdaptiveStepsizeIntegrator(String string, double d, double d2, double d3, double d4) {
        super(string);
        this.setStepSizeControl(d, d2, d3, d4);
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(String string, double d, double d2, double[] dArray, double[] dArray2) {
        super(string);
        this.setStepSizeControl(d, d2, dArray, dArray2);
        this.resetInternalState();
    }

    public void setStepSizeControl(double d, double d2, double d3, double d4) {
        this.minStep = FastMath.abs(d);
        this.maxStep = FastMath.abs(d2);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = d3;
        this.scalRelativeTolerance = d4;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double d, double d2, double[] dArray, double[] dArray2) {
        this.minStep = FastMath.abs(d);
        this.maxStep = FastMath.abs(d2);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])dArray.clone();
        this.vecRelativeTolerance = (double[])dArray2.clone();
    }

    public void setInitialStepSize(double d) {
        this.initialStep = d < this.minStep || d > this.maxStep ? -1.0 : d;
    }

    protected void sanityChecks(ExpandableStatefulODE expandableStatefulODE, double d) {
        super.sanityChecks(expandableStatefulODE, d);
        this.mainSetDimension = expandableStatefulODE.getPrimaryMapper().getDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public double initializeStep(boolean bl, int n, double[] dArray, double d, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d2;
        double d3;
        if (this.initialStep > 0.0) {
            return bl ? this.initialStep : -this.initialStep;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 = dArray2[i] / dArray[i];
            d4 += d3 * d3;
            d3 = dArray3[i] / dArray[i];
            d5 += d3 * d3;
        }
        double d6 = d2 = d4 < 1.0E-10 || d5 < 1.0E-10 ? 1.0E-6 : 0.01 * FastMath.sqrt(d4 / d5);
        if (!bl) {
            d2 = -d2;
        }
        for (int i = 0; i < dArray2.length; ++i) {
            dArray4[i] = dArray2[i] + d2 * dArray3[i];
        }
        this.computeDerivatives(d + d2, dArray4, dArray5);
        double d7 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 = (dArray5[i] - dArray3[i]) / dArray[i];
            d7 += d3 * d3;
        }
        d7 = FastMath.sqrt(d7) / d2;
        double d8 = FastMath.max(FastMath.sqrt(d5), d7);
        double d9 = d8 < 1.0E-15 ? FastMath.max(1.0E-6, 0.001 * FastMath.abs(d2)) : FastMath.pow(0.01 / d8, 1.0 / (double)n);
        d2 = FastMath.min(100.0 * FastMath.abs(d2), d9);
        if ((d2 = FastMath.max(d2, 1.0E-12 * FastMath.abs(d))) < this.getMinStep()) {
            d2 = this.getMinStep();
        }
        if (d2 > this.getMaxStep()) {
            d2 = this.getMaxStep();
        }
        if (!bl) {
            d2 = -d2;
        }
        return d2;
    }

    protected double filterStep(double d, boolean bl, boolean bl2) {
        double d2 = d;
        if (FastMath.abs(d) < this.minStep) {
            if (bl2) {
                d2 = bl ? this.minStep : -this.minStep;
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)FastMath.abs(d), this.minStep, true);
            }
        }
        if (d2 > this.maxStep) {
            d2 = this.maxStep;
        } else if (d2 < -this.maxStep) {
            d2 = -this.maxStep;
        }
        return d2;
    }

    public abstract void integrate(ExpandableStatefulODE var1, double var2);

    public double getCurrentStepStart() {
        return this.stepStart;
    }

    protected void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = FastMath.sqrt(this.minStep * this.maxStep);
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

