/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class ClassicalRungeKuttaStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public ClassicalRungeKuttaStepInterpolator() {
    }

    ClassicalRungeKuttaStepInterpolator(ClassicalRungeKuttaStepInterpolator classicalRungeKuttaStepInterpolator) {
        super(classicalRungeKuttaStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new ClassicalRungeKuttaStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 1.0 - d;
        double d4 = 1.0 - 2.0 * d;
        double d5 = d3 * d4;
        double d6 = 2.0 * d * d3;
        double d7 = -d * d4;
        if (this.previousState != null && d <= 0.5) {
            double d8 = 4.0 * d * d;
            double d9 = d * this.h / 6.0;
            double d10 = d9 * (6.0 - 9.0 * d + d8);
            double d11 = d9 * (6.0 * d - d8);
            double d12 = d9 * (-3.0 * d + d8);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d13 = this.yDotK[0][i];
                double d14 = this.yDotK[1][i] + this.yDotK[2][i];
                double d15 = this.yDotK[3][i];
                this.interpolatedState[i] = this.previousState[i] + d10 * d13 + d11 * d14 + d12 * d15;
                this.interpolatedDerivatives[i] = d5 * d13 + d6 * d14 + d7 * d15;
            }
        } else {
            double d16 = 4.0 * d;
            double d17 = d2 / 6.0;
            double d18 = d17 * ((-d16 + 5.0) * d - 1.0);
            double d19 = d17 * ((d16 - 2.0) * d - 2.0);
            double d20 = d17 * ((-d16 - 1.0) * d - 1.0);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d21 = this.yDotK[0][i];
                double d22 = this.yDotK[1][i] + this.yDotK[2][i];
                double d23 = this.yDotK[3][i];
                this.interpolatedState[i] = this.currentState[i] + d18 * d21 + d19 * d22 + d20 * d23;
                this.interpolatedDerivatives[i] = d5 * d21 + d6 * d22 + d7 * d23;
            }
        }
    }
}

