/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DormandPrince853FieldIntegrator<T extends RealFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    private static final String METHOD_NAME = "Dormand-Prince 8 (5, 3)";
    private final T e1_01 = this.fraction(1.16092271E8, 8.84846592E9);
    private final T e1_06 = this.fraction(-1871647.0, 1527680.0);
    private final T e1_07 = this.fraction(-6.9799717E7, 1.4079366E8);
    private final T e1_08 = this.fraction(1.230164450203E12, 7.39113984E11);
    private final T e1_09 = this.fraction(-1.980813971228885E15, 5.654156025964544E15);
    private final T e1_10 = this.fraction(4.64500805E8, 1.389975552E9);
    private final T e1_11 = this.fraction(1.606764981773E12, 1.9613062656E13);
    private final T e1_12 = this.fraction(-137909.0, 6168960.0);
    private final T e2_01 = this.fraction(-364463.0, 1920240.0);
    private final T e2_06 = this.fraction(3399327.0, 763840.0);
    private final T e2_07 = this.fraction(6.6578432E7, 3.5198415E7);
    private final T e2_08 = this.fraction(-1.674902723E9, 2.887164E8);
    private final T e2_09 = this.fraction(-7.4684743568175E13, 1.76692375811392E14);
    private final T e2_10 = this.fraction(-734375.0, 4826304.0);
    private final T e2_11 = this.fraction(1.71414593E8, 8.512614E8);
    private final T e2_12 = this.fraction(69869.0, 3084480.0);

    public DormandPrince853FieldIntegrator(Field<T> field, double d, double d2, double d3, double d4) {
        super(field, METHOD_NAME, 12, d, d2, d3, d4);
    }

    public DormandPrince853FieldIntegrator(Field<T> field, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, 12, d, d2, dArray, dArray2);
    }

    @Override
    public T[] getC() {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(6)).sqrt();
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 15);
        realFieldElementArray[0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-67.5);
        realFieldElementArray[1] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-45.0);
        realFieldElementArray[2] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-30.0);
        realFieldElementArray[3] = (RealFieldElement)((RealFieldElement)realFieldElement.add(6.0)).divide(30.0);
        realFieldElementArray[4] = this.fraction(1, 3);
        realFieldElementArray[5] = this.fraction(1, 4);
        realFieldElementArray[6] = this.fraction(4, 13);
        realFieldElementArray[7] = this.fraction(127, 195);
        realFieldElementArray[8] = this.fraction(3, 5);
        realFieldElementArray[9] = this.fraction(6, 7);
        realFieldElementArray[10] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray[11] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray[12] = this.fraction(1.0, 10.0);
        realFieldElementArray[13] = this.fraction(1.0, 5.0);
        realFieldElementArray[14] = this.fraction(7.0, 9.0);
        return realFieldElementArray;
    }

    @Override
    public T[][] getA() {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(6)).sqrt();
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 15, -1);
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            realFieldElementArray[i] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i + 1);
        }
        realFieldElementArray[0][0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-67.5);
        realFieldElementArray[1][0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-180.0);
        realFieldElementArray[1][1] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-60.0);
        realFieldElementArray[2][0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-120.0);
        realFieldElementArray[2][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][2] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-6.0)).divide(-40.0);
        realFieldElementArray[3][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(107)).add(462.0)).divide(3000.0);
        realFieldElementArray[3][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[3][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(197)).add(402.0)).divide(-1000.0);
        realFieldElementArray[3][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(73)).add(168.0)).divide(375.0);
        realFieldElementArray[4][0] = this.fraction(1, 27);
        realFieldElementArray[4][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[4][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[4][3] = (RealFieldElement)((RealFieldElement)realFieldElement.add(16.0)).divide(108.0);
        realFieldElementArray[4][4] = (RealFieldElement)((RealFieldElement)realFieldElement.add(-16.0)).divide(-108.0);
        realFieldElementArray[5][0] = this.fraction(19, 512);
        realFieldElementArray[5][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(23)).add(118.0)).divide(1024.0);
        realFieldElementArray[5][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-23)).add(118.0)).divide(1024.0);
        realFieldElementArray[5][5] = this.fraction(-9, 512);
        realFieldElementArray[6][0] = this.fraction(13772, 371293);
        realFieldElementArray[6][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[6][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[6][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(4784)).add(51544.0)).divide(371293.0);
        realFieldElementArray[6][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-4784)).add(51544.0)).divide(371293.0);
        realFieldElementArray[6][5] = this.fraction(-5688, 371293);
        realFieldElementArray[6][6] = this.fraction(3072, 371293);
        realFieldElementArray[7][0] = this.fraction(5.8656157643E10, 9.3983540625E10);
        realFieldElementArray[7][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[7][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[7][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-3.18801444819E11)).add(-1.324889724104E12)).divide(6.265569375E11);
        realFieldElementArray[7][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(3.18801444819E11)).add(-1.324889724104E12)).divide(6.265569375E11);
        realFieldElementArray[7][5] = this.fraction(9.6044563816E10, 3.480871875E9);
        realFieldElementArray[7][6] = this.fraction(5.682451879168E12, 2.81950621875E11);
        realFieldElementArray[7][7] = this.fraction(-1.65125654E8, 3796875.0);
        realFieldElementArray[8][0] = this.fraction(8909899.0, 1.8653125E7);
        realFieldElementArray[8][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[8][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[8][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-1137963.0)).add(-4521408.0)).divide(2937500.0);
        realFieldElementArray[8][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(1137963.0)).add(-4521408.0)).divide(2937500.0);
        realFieldElementArray[8][5] = this.fraction(9.6663078E7, 4553125.0);
        realFieldElementArray[8][6] = this.fraction(2.107245056E9, 1.37915625E8);
        realFieldElementArray[8][7] = this.fraction(-4.913652016E9, 1.47609375E8);
        realFieldElementArray[8][8] = this.fraction(-7.889427E7, 3.880452869E9);
        realFieldElementArray[9][0] = this.fraction(-2.0401265806E10, 2.1769653311E10);
        realFieldElementArray[9][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[9][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[9][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(94326.0)).add(354216.0)).divide(112847.0);
        realFieldElementArray[9][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-94326.0)).add(354216.0)).divide(112847.0);
        realFieldElementArray[9][5] = this.fraction(-4.3306765128E10, 5.313852383E9);
        realFieldElementArray[9][6] = this.fraction(-2.0866708358144E13, 1.126708119789E12);
        realFieldElementArray[9][7] = this.fraction(1.488600343802E13, 6.54632330667E11);
        realFieldElementArray[9][8] = this.fraction(3.5290686222309376E16, 1.4152473387134412E16);
        realFieldElementArray[9][9] = this.fraction(-1.477884375E9, 4.85066827E8);
        realFieldElementArray[10][0] = this.fraction(3.9815761E7, 1.7514443E7);
        realFieldElementArray[10][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[10][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[10][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(-960905.0)).add(-3457480.0)).divide(551636.0);
        realFieldElementArray[10][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.multiply(960905.0)).add(-3457480.0)).divide(551636.0);
        realFieldElementArray[10][5] = this.fraction(-8.44554132E8, 4.7026969E7);
        realFieldElementArray[10][6] = this.fraction(8.444996352E9, 3.02158619E8);
        realFieldElementArray[10][7] = this.fraction(-2.509602342E9, 8.77790785E8);
        realFieldElementArray[10][8] = this.fraction(-2.838879529799625E16, 3.199510091356783E15);
        realFieldElementArray[10][9] = this.fraction(2.2671625E8, 1.8341897E7);
        realFieldElementArray[10][10] = this.fraction(1.371316744E9, 2.131383595E9);
        realFieldElementArray[11][0] = this.fraction(104257.0, 1920240.0);
        realFieldElementArray[11][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[11][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[11][3] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[11][4] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[11][5] = this.fraction(3399327.0, 763840.0);
        realFieldElementArray[11][6] = this.fraction(6.6578432E7, 3.5198415E7);
        realFieldElementArray[11][7] = this.fraction(-1.674902723E9, 2.887164E8);
        realFieldElementArray[11][8] = this.fraction(5.4980371265625E13, 1.76692375811392E14);
        realFieldElementArray[11][9] = this.fraction(-734375.0, 4826304.0);
        realFieldElementArray[11][10] = this.fraction(1.71414593E8, 8.512614E8);
        realFieldElementArray[11][11] = this.fraction(137909.0, 3084480.0);
        realFieldElementArray[12][0] = this.fraction(1.3481885573E10, 2.4003E11);
        realFieldElementArray[12][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[12][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[12][3] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[12][4] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[12][5] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[12][6] = this.fraction(1.39418837528E11, 5.49975234375E11);
        realFieldElementArray[12][7] = this.fraction(-1.1108320068443E13, 4.51119375E13);
        realFieldElementArray[12][8] = this.fraction(-1.769651421925959E15, 1.424938514608E16);
        realFieldElementArray[12][9] = this.fraction(5.7799439E7, 3.77055E8);
        realFieldElementArray[12][10] = this.fraction(7.93322643029E11, 9.673425E13);
        realFieldElementArray[12][11] = this.fraction(1.458939311E9, 1.9278E11);
        realFieldElementArray[12][12] = this.fraction(-4149.0, 500000.0);
        realFieldElementArray[13][0] = this.fraction(1.595561272731E12, 5.01202735E13);
        realFieldElementArray[13][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][3] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][4] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][5] = this.fraction(9.75183916491E11, 3.445768803125E13);
        realFieldElementArray[13][6] = this.fraction(3.8492013932672E13, 7.18912673015625E14);
        realFieldElementArray[13][7] = this.fraction(-1.114881286517557E15, 2.02987107675E16);
        realFieldElementArray[13][8] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][9] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13][10] = this.fraction(-2.538710946863E12, 2.343122786125E16);
        realFieldElementArray[13][11] = this.fraction(8.824659001E9, 2.306671678125E13);
        realFieldElementArray[13][12] = this.fraction(-1.1518334563E10, 3.38311846125E13);
        realFieldElementArray[13][13] = this.fraction(1.912306948E9, 1.3532473845E10);
        realFieldElementArray[14][0] = this.fraction(-1.3613986967E10, 3.1741908048E10);
        realFieldElementArray[14][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][3] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][4] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][5] = this.fraction(-4.755612631E9, 1.012344804E9);
        realFieldElementArray[14][6] = this.fraction(4.2939257944576E13, 5.588559685701E12);
        realFieldElementArray[14][7] = this.fraction(7.7881972900277E13, 1.9140370552944E13);
        realFieldElementArray[14][8] = this.fraction(2.2719829234375E13, 6.3689648654052E13);
        realFieldElementArray[14][9] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][10] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][11] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14][12] = this.fraction(-1.199007803E9, 8.57031517296E11);
        realFieldElementArray[14][13] = this.fraction(1.57882067E11, 5.3564469831E10);
        realFieldElementArray[14][14] = this.fraction(-2.90468882375E11, 3.1741908048E10);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 16);
        realFieldElementArray[0] = this.fraction(104257, 1920240);
        realFieldElementArray[1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[3] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[4] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5] = this.fraction(3399327.0, 763840.0);
        realFieldElementArray[6] = this.fraction(6.6578432E7, 3.5198415E7);
        realFieldElementArray[7] = this.fraction(-1.674902723E9, 2.887164E8);
        realFieldElementArray[8] = this.fraction(5.4980371265625E13, 1.76692375811392E14);
        realFieldElementArray[9] = this.fraction(-734375.0, 4826304.0);
        realFieldElementArray[10] = this.fraction(1.71414593E8, 8.512614E8);
        realFieldElementArray[11] = this.fraction(137909.0, 3084480.0);
        realFieldElementArray[12] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[13] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[14] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[15] = (RealFieldElement)this.getField().getZero();
        return realFieldElementArray;
    }

    @Override
    protected DormandPrince853FieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new DormandPrince853FieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }

    @Override
    public int getOrder() {
        return 8;
    }

    @Override
    protected T estimateError(T[][] TArray, T[] TArray2, T[] TArray3, T t) {
        RealFieldElement realFieldElement = (RealFieldElement)t.getField().getZero();
        RealFieldElement realFieldElement2 = (RealFieldElement)t.getField().getZero();
        for (int i = 0; i < this.mainSetDimension; ++i) {
            RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][i].multiply(this.e1_01)).add(TArray[5][i].multiply(this.e1_06))).add(TArray[6][i].multiply(this.e1_07))).add(TArray[7][i].multiply(this.e1_08))).add(TArray[8][i].multiply(this.e1_09))).add(TArray[9][i].multiply(this.e1_10))).add(TArray[10][i].multiply(this.e1_11))).add(TArray[11][i].multiply(this.e1_12));
            RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][i].multiply(this.e2_01)).add(TArray[5][i].multiply(this.e2_06))).add(TArray[6][i].multiply(this.e2_07))).add(TArray[7][i].multiply(this.e2_08))).add(TArray[8][i].multiply(this.e2_09))).add(TArray[9][i].multiply(this.e2_10))).add(TArray[10][i].multiply(this.e2_11))).add(TArray[11][i].multiply(this.e2_12));
            RealFieldElement realFieldElement5 = MathUtils.max((RealFieldElement)TArray2[i].abs(), (RealFieldElement)TArray3[i].abs());
            RealFieldElement realFieldElement6 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement5.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement5.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
            RealFieldElement realFieldElement7 = realFieldElement3.divide(realFieldElement6);
            realFieldElement = realFieldElement.add(realFieldElement7.multiply(realFieldElement7));
            RealFieldElement realFieldElement8 = realFieldElement4.divide(realFieldElement6);
            realFieldElement2 = realFieldElement2.add(realFieldElement8.multiply(realFieldElement8));
        }
        RealFieldElement realFieldElement9 = (RealFieldElement)realFieldElement.add(realFieldElement2.multiply(0.01));
        if (realFieldElement9.getReal() <= 0.0) {
            realFieldElement9 = (RealFieldElement)t.getField().getOne();
        }
        return (T)((RealFieldElement)((RealFieldElement)t.abs()).multiply(realFieldElement).divide(((RealFieldElement)realFieldElement9.multiply(this.mainSetDimension)).sqrt()));
    }
}

