/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.GillFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GillFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public GillFieldIntegrator(Field<T> field, T t) {
        super(field, "Gill", t);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 3);
        realFieldElementArray[0] = this.fraction(1, 2);
        realFieldElementArray[1] = realFieldElementArray[0];
        realFieldElementArray[2] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray;
    }

    @Override
    public T[][] getA() {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(2.0);
        RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElement.sqrt();
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 3, -1);
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            realFieldElementArray[i] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i + 1);
        }
        realFieldElementArray[0][0] = this.fraction(1, 2);
        realFieldElementArray[1][0] = (RealFieldElement)((RealFieldElement)realFieldElement2.subtract(1.0)).multiply(0.5);
        realFieldElementArray[1][1] = (RealFieldElement)((RealFieldElement)realFieldElement2.subtract(2.0)).multiply(-0.5);
        realFieldElementArray[2][0] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][1] = (RealFieldElement)realFieldElement2.multiply(-0.5);
        realFieldElementArray[2][2] = (RealFieldElement)((RealFieldElement)realFieldElement2.add(2.0)).multiply(0.5);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(2.0);
        RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElement.sqrt();
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 4);
        realFieldElementArray[0] = this.fraction(1, 6);
        realFieldElementArray[1] = (RealFieldElement)((RealFieldElement)realFieldElement2.subtract(2.0)).divide(-6.0);
        realFieldElementArray[2] = (RealFieldElement)((RealFieldElement)realFieldElement2.add(2.0)).divide(6.0);
        realFieldElementArray[3] = realFieldElementArray[0];
        return realFieldElementArray;
    }

    @Override
    protected GillFieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new GillFieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }
}

