/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GillFieldStepInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStepInterpolator<T> {
    private final T one_minus_inv_sqrt_2;
    private final T one_plus_inv_sqrt_2;

    GillFieldStepInterpolator(Field<T> field, boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        super(field, bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)field.getZero()).add(0.5)).sqrt();
        this.one_minus_inv_sqrt_2 = ((RealFieldElement)field.getOne()).subtract(realFieldElement);
        this.one_plus_inv_sqrt_2 = ((RealFieldElement)field.getOne()).add(realFieldElement);
    }

    @Override
    protected GillFieldStepInterpolator<T> create(Field<T> field, boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new GillFieldStepInterpolator(field, bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> fieldEquationsMapper, T t, T n, T t2, T t3) {
        RealFieldElement[] realFieldElementArray;
        RealFieldElement[] realFieldElementArray2;
        RealFieldElement realFieldElement = (RealFieldElement)t.getField().getOne();
        RealFieldElement realFieldElement2 = (RealFieldElement)n.multiply((int)2);
        RealFieldElement realFieldElement3 = realFieldElement2.multiply(realFieldElement2);
        RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)n.multiply(realFieldElement2.subtract(3.0))).add(1.0);
        RealFieldElement realFieldElement5 = (RealFieldElement)realFieldElement2.multiply(realFieldElement.subtract(n));
        RealFieldElement realFieldElement6 = (RealFieldElement)realFieldElement5.multiply(this.one_minus_inv_sqrt_2);
        RealFieldElement realFieldElement7 = (RealFieldElement)realFieldElement5.multiply(this.one_plus_inv_sqrt_2);
        RealFieldElement realFieldElement8 = (RealFieldElement)n.multiply(realFieldElement2.subtract(1.0));
        if (this.getGlobalPreviousState() != null && n.getReal() <= 0.5) {
            RealFieldElement realFieldElement9 = (RealFieldElement)t2.divide(6.0);
            RealFieldElement realFieldElement10 = realFieldElement9.multiply(((RealFieldElement)n.multiply((int)6)).subtract(realFieldElement3));
            RealFieldElement realFieldElement11 = (RealFieldElement)realFieldElement9.multiply(((RealFieldElement)realFieldElement3.subtract(n.multiply((int)9))).add(6.0));
            RealFieldElement realFieldElement12 = (RealFieldElement)realFieldElement10.multiply(this.one_minus_inv_sqrt_2);
            RealFieldElement realFieldElement13 = (RealFieldElement)realFieldElement10.multiply(this.one_plus_inv_sqrt_2);
            RealFieldElement realFieldElement14 = (RealFieldElement)realFieldElement9.multiply(realFieldElement3.subtract(n.multiply((int)3)));
            realFieldElementArray2 = this.previousStateLinearCombination(new RealFieldElement[]{realFieldElement11, realFieldElement12, realFieldElement13, realFieldElement14});
            realFieldElementArray = this.derivativeLinearCombination(new RealFieldElement[]{realFieldElement4, realFieldElement6, realFieldElement7, realFieldElement8});
        } else {
            RealFieldElement realFieldElement15 = (RealFieldElement)t3.divide(-6.0);
            RealFieldElement realFieldElement16 = realFieldElement15.multiply(((RealFieldElement)realFieldElement2.add(2.0)).subtract(realFieldElement3));
            RealFieldElement realFieldElement17 = (RealFieldElement)realFieldElement15.multiply(((RealFieldElement)realFieldElement3.subtract(n.multiply((int)5))).add(1.0));
            RealFieldElement realFieldElement18 = (RealFieldElement)realFieldElement16.multiply(this.one_minus_inv_sqrt_2);
            RealFieldElement realFieldElement19 = (RealFieldElement)realFieldElement16.multiply(this.one_plus_inv_sqrt_2);
            RealFieldElement realFieldElement20 = (RealFieldElement)realFieldElement15.multiply(((RealFieldElement)realFieldElement3.add(n)).add(1.0));
            realFieldElementArray2 = this.currentStateLinearCombination(new RealFieldElement[]{realFieldElement17, realFieldElement18, realFieldElement19, realFieldElement20});
            realFieldElementArray = this.derivativeLinearCombination(new RealFieldElement[]{realFieldElement4, realFieldElement6, realFieldElement7, realFieldElement8});
        }
        return new FieldODEStateAndDerivative(t, realFieldElementArray2, realFieldElementArray);
    }
}

