/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

class GillStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final double ONE_MINUS_INV_SQRT_2 = 1.0 - FastMath.sqrt(0.5);
    private static final double ONE_PLUS_INV_SQRT_2 = 1.0 + FastMath.sqrt(0.5);
    private static final long serialVersionUID = 20111120L;

    public GillStepInterpolator() {
    }

    GillStepInterpolator(GillStepInterpolator gillStepInterpolator) {
        super(gillStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new GillStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 2.0 * d;
        double d4 = d3 * d3;
        double d5 = d * (d3 - 3.0) + 1.0;
        double d6 = d3 * (1.0 - d);
        double d7 = d6 * ONE_MINUS_INV_SQRT_2;
        double d8 = d6 * ONE_PLUS_INV_SQRT_2;
        double d9 = d * (d3 - 1.0);
        if (this.previousState != null && d <= 0.5) {
            double d10 = d * this.h / 6.0;
            double d11 = d10 * (6.0 * d - d4);
            double d12 = d10 * (6.0 - 9.0 * d + d4);
            double d13 = d11 * ONE_MINUS_INV_SQRT_2;
            double d14 = d11 * ONE_PLUS_INV_SQRT_2;
            double d15 = d10 * (-3.0 * d + d4);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d16 = this.yDotK[0][i];
                double d17 = this.yDotK[1][i];
                double d18 = this.yDotK[2][i];
                double d19 = this.yDotK[3][i];
                this.interpolatedState[i] = this.previousState[i] + d12 * d16 + d13 * d17 + d14 * d18 + d15 * d19;
                this.interpolatedDerivatives[i] = d5 * d16 + d7 * d17 + d8 * d18 + d9 * d19;
            }
        } else {
            double d20 = d2 / 6.0;
            double d21 = d20 * (2.0 + d3 - d4);
            double d22 = d20 * (1.0 - 5.0 * d + d4);
            double d23 = d21 * ONE_MINUS_INV_SQRT_2;
            double d24 = d21 * ONE_PLUS_INV_SQRT_2;
            double d25 = d20 * (1.0 + d + d4);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d26 = this.yDotK[0][i];
                double d27 = this.yDotK[1][i];
                double d28 = this.yDotK[2][i];
                double d29 = this.yDotK[3][i];
                this.interpolatedState[i] = this.currentState[i] - d22 * d26 - d23 * d27 - d24 * d28 - d25 * d29;
                this.interpolatedDerivatives[i] = d5 * d26 + d7 * d27 + d8 * d28 + d9 * d29;
            }
        }
    }
}

