/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.util.FastMath;

public class GraggBulirschStoerIntegrator
extends AdaptiveStepsizeIntegrator {
    private static final String METHOD_NAME = "Gragg-Bulirsch-Stoer";
    private int maxOrder;
    private int[] sequence;
    private int[] costPerStep;
    private double[] costPerTimeUnit;
    private double[] optimalStep;
    private double[][] coeff;
    private boolean performTest;
    private int maxChecks;
    private int maxIter;
    private double stabilityReduction;
    private double stepControl1;
    private double stepControl2;
    private double stepControl3;
    private double stepControl4;
    private double orderControl1;
    private double orderControl2;
    private boolean useInterpolationError;
    private int mudif;

    public GraggBulirschStoerIntegrator(double d, double d2, double d3, double d4) {
        super(METHOD_NAME, d, d2, d3, d4);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public GraggBulirschStoerIntegrator(double d, double d2, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, d, d2, dArray, dArray2);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public void setStabilityCheck(boolean bl, int n, int n2, double d) {
        this.performTest = bl;
        this.maxIter = n <= 0 ? 2 : n;
        this.maxChecks = n2 <= 0 ? 1 : n2;
        this.stabilityReduction = d < 1.0E-4 || d > 0.9999 ? 0.5 : d;
    }

    public void setControlFactors(double d, double d2, double d3, double d4) {
        this.stepControl1 = d < 1.0E-4 || d > 0.9999 ? 0.65 : d;
        this.stepControl2 = d2 < 1.0E-4 || d2 > 0.9999 ? 0.94 : d2;
        this.stepControl3 = d3 < 1.0E-4 || d3 > 0.9999 ? 0.02 : d3;
        this.stepControl4 = d4 < 1.0001 || d4 > 999.9 ? 4.0 : d4;
    }

    public void setOrderControl(int n, double d, double d2) {
        if (n <= 6 || n % 2 != 0) {
            this.maxOrder = 18;
        }
        this.orderControl1 = d < 1.0E-4 || d > 0.9999 ? 0.8 : d;
        this.orderControl2 = d2 < 1.0E-4 || d2 > 0.9999 ? 0.9 : d2;
        this.initializeArrays();
    }

    public void addStepHandler(StepHandler stepHandler) {
        super.addStepHandler(stepHandler);
        this.initializeArrays();
    }

    public void addEventHandler(EventHandler eventHandler, double d, double d2, int n, UnivariateSolver univariateSolver) {
        super.addEventHandler(eventHandler, d, d2, n, univariateSolver);
        this.initializeArrays();
    }

    private void initializeArrays() {
        int n;
        int n2 = this.maxOrder / 2;
        if (this.sequence == null || this.sequence.length != n2) {
            this.sequence = new int[n2];
            this.costPerStep = new int[n2];
            this.coeff = new double[n2][];
            this.costPerTimeUnit = new double[n2];
            this.optimalStep = new double[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.sequence[n] = 4 * n + 2;
        }
        this.costPerStep[0] = this.sequence[0] + 1;
        for (n = 1; n < n2; ++n) {
            this.costPerStep[n] = this.costPerStep[n - 1] + this.sequence[n];
        }
        for (n = 0; n < n2; ++n) {
            this.coeff[n] = n > 0 ? new double[n] : null;
            for (int i = 0; i < n; ++i) {
                double d = (double)this.sequence[n] / (double)this.sequence[n - i - 1];
                this.coeff[n][i] = 1.0 / (d * d - 1.0);
            }
        }
    }

    public void setInterpolationControl(boolean bl, int n) {
        this.useInterpolationError = bl;
        this.mudif = n <= 0 || n >= 7 ? 4 : n;
    }

    private void rescale(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.vecAbsoluteTolerance == null) {
            for (int i = 0; i < dArray3.length; ++i) {
                double d = FastMath.max(FastMath.abs(dArray[i]), FastMath.abs(dArray2[i]));
                dArray3[i] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * d;
            }
        } else {
            for (int i = 0; i < dArray3.length; ++i) {
                double d = FastMath.max(FastMath.abs(dArray[i]), FastMath.abs(dArray2[i]));
                dArray3[i] = this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * d;
            }
        }
    }

    private boolean tryStep(double d, double[] dArray, double d2, int n, double[] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n2;
        int n3 = this.sequence[n];
        double d3 = d2 / (double)n3;
        double d4 = 2.0 * d3;
        double d5 = d + d3;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray6[n2] = dArray[n2];
            dArray5[n2] = dArray[n2] + d3 * dArray3[0][n2];
        }
        this.computeDerivatives(d5, dArray5, dArray3[1]);
        for (n2 = 1; n2 < n3; ++n2) {
            if (2 * n2 == n3) {
                System.arraycopy(dArray5, 0, dArray4, 0, dArray.length);
            }
            d5 += d3;
            for (int i = 0; i < dArray.length; ++i) {
                double d6 = dArray5[i];
                dArray5[i] = dArray6[i] + d4 * dArray3[n2][i];
                dArray6[i] = d6;
            }
            this.computeDerivatives(d5, dArray5, dArray3[n2 + 1]);
            if (!this.performTest || n2 > this.maxChecks || n >= this.maxIter) continue;
            double d7 = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                double d8 = dArray3[0][i] / dArray2[i];
                d7 += d8 * d8;
            }
            double d9 = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                double d10 = (dArray3[n2 + 1][i] - dArray3[0][i]) / dArray2[i];
                d9 += d10 * d10;
            }
            if (!(d9 > 4.0 * FastMath.max(1.0E-15, d7))) continue;
            return false;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray5[n2] = 0.5 * (dArray6[n2] + dArray5[n2] + d3 * dArray3[n3][n2]);
        }
        return true;
    }

    private void extrapolate(int n, int n2, double[][] dArray, double[] dArray2) {
        int n3;
        for (n3 = 1; n3 < n2; ++n3) {
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[n2 - n3 - 1][i] = dArray[n2 - n3][i] + this.coeff[n2 + n][n3 - 1] * (dArray[n2 - n3][i] - dArray[n2 - n3 - 1][i]);
            }
        }
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray[0][n3] + this.coeff[n2 + n][n2 - 1] * (dArray[0][n3] - dArray2[n3]);
        }
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d) {
        this.sanityChecks(expandableStatefulODE, d);
        this.setEquations(expandableStatefulODE);
        boolean bl = d > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[] dArray5 = new double[dArray2.length];
        double[] dArray6 = new double[dArray2.length];
        double[][] dArrayArray = new double[this.sequence.length - 1][];
        double[][] dArrayArray2 = new double[this.sequence.length - 1][];
        for (int i = 0; i < this.sequence.length - 1; ++i) {
            dArrayArray[i] = new double[dArray2.length];
            dArrayArray2[i] = new double[dArray2.length];
        }
        double[][][] dArrayArray3 = new double[this.sequence.length][][];
        for (int i = 0; i < this.sequence.length; ++i) {
            dArrayArray3[i] = new double[this.sequence[i] + 1][];
            dArrayArray3[i][0] = dArray3;
            for (int j = 0; j < this.sequence[i]; ++j) {
                dArrayArray3[i][j + 1] = new double[dArray.length];
            }
        }
        if (dArray2 != dArray) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        }
        double[] dArray7 = new double[dArray.length];
        double[][] dArray8 = new double[1 + 2 * this.sequence.length][dArray.length];
        double[] dArray9 = new double[this.mainSetDimension];
        this.rescale(dArray2, dArray2, dArray9);
        double d2 = this.vecRelativeTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[0];
        double d3 = FastMath.log10(FastMath.max(1.0E-10, d2));
        int n = FastMath.max(1, FastMath.min(this.sequence.length - 2, (int)FastMath.floor(0.5 - 0.6 * d3)));
        GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator = new GraggBulirschStoerStepInterpolator(dArray2, dArray3, dArray4, dArray7, dArray8, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        graggBulirschStoerStepInterpolator.storeTime(expandableStatefulODE.getTime());
        this.stepStart = expandableStatefulODE.getTime();
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d);
        this.costPerTimeUnit[0] = 0.0;
        this.isLastStep = false;
        do {
            double d6;
            boolean bl6 = false;
            if (bl4) {
                graggBulirschStoerStepInterpolator.shift();
                if (!bl5) {
                    this.computeDerivatives(this.stepStart, dArray2, dArray3);
                }
                if (bl3) {
                    d4 = this.initializeStep(bl, 2 * n + 1, dArray9, this.stepStart, dArray2, dArray3, dArray5, dArray6);
                }
                bl4 = false;
            }
            this.stepSize = d4;
            if (bl && this.stepStart + this.stepSize > d || !bl && this.stepStart + this.stepSize < d) {
                this.stepSize = d - this.stepStart;
            }
            double d7 = this.stepStart + this.stepSize;
            this.isLastStep = bl ? d7 >= d : d7 <= d;
            int n2 = -1;
            boolean bl7 = true;
            block9: while (bl7) {
                if (!this.tryStep(this.stepStart, dArray2, this.stepSize, n2, dArray9, dArrayArray3[++n2], n2 == 0 ? dArray8[0] : dArrayArray[n2 - 1], n2 == 0 ? dArray4 : dArrayArray2[n2 - 1], dArray5)) {
                    d4 = FastMath.abs(this.filterStep(this.stepSize * this.stabilityReduction, bl, false));
                    bl6 = true;
                    bl7 = false;
                    continue;
                }
                if (n2 <= 0) continue;
                this.extrapolate(0, n2, dArrayArray2, dArray4);
                this.rescale(dArray2, dArray4, dArray9);
                double d8 = 0.0;
                for (int i = 0; i < this.mainSetDimension; ++i) {
                    double d9 = FastMath.abs(dArray4[i] - dArrayArray2[0][i]) / dArray9[i];
                    d8 += d9 * d9;
                }
                if ((d8 = FastMath.sqrt(d8 / (double)this.mainSetDimension)) > 1.0E15 || n2 > 1 && d8 > d5) {
                    d4 = FastMath.abs(this.filterStep(this.stepSize * this.stabilityReduction, bl, false));
                    bl6 = true;
                    bl7 = false;
                    continue;
                }
                d5 = FastMath.max(4.0 * d8, 1.0);
                double d10 = 1.0 / (double)(2 * n2 + 1);
                double d11 = this.stepControl2 / FastMath.pow(d8 / this.stepControl1, d10);
                d6 = FastMath.pow(this.stepControl3, d10);
                d11 = FastMath.max(d6 / this.stepControl4, FastMath.min(1.0 / d6, d11));
                this.optimalStep[n2] = FastMath.abs(this.filterStep(this.stepSize * d11, bl, true));
                this.costPerTimeUnit[n2] = (double)this.costPerStep[n2] / this.optimalStep[n2];
                switch (n2 - n) {
                    case -1: {
                        if (n <= 1 || bl2) continue block9;
                        if (d8 <= 1.0) {
                            bl7 = false;
                            break;
                        }
                        double d12 = (double)this.sequence[n] * (double)this.sequence[n + 1] / (double)(this.sequence[0] * this.sequence[0]);
                        if (!(d8 > d12 * d12)) continue block9;
                        bl6 = true;
                        bl7 = false;
                        n = n2;
                        if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                            --n;
                        }
                        d4 = this.optimalStep[n];
                        break;
                    }
                    case 0: {
                        if (d8 <= 1.0) {
                            bl7 = false;
                            break;
                        }
                        double d12 = (double)this.sequence[n2 + 1] / (double)this.sequence[0];
                        if (!(d8 > d12 * d12)) continue block9;
                        bl6 = true;
                        bl7 = false;
                        if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                            --n;
                        }
                        d4 = this.optimalStep[n];
                        break;
                    }
                    case 1: {
                        if (d8 > 1.0) {
                            bl6 = true;
                            if (n > 1 && this.costPerTimeUnit[n - 1] < this.orderControl1 * this.costPerTimeUnit[n]) {
                                --n;
                            }
                            d4 = this.optimalStep[n];
                        }
                        bl7 = false;
                        break;
                    }
                    default: {
                        if (!bl3 && !this.isLastStep || !(d8 <= 1.0)) continue block9;
                        bl7 = false;
                    }
                }
            }
            if (!bl6) {
                this.computeDerivatives(this.stepStart + this.stepSize, dArray4, dArray7);
            }
            double d13 = this.getMaxStep();
            if (!bl6) {
                int n3;
                for (n3 = 1; n3 <= n2; ++n3) {
                    this.extrapolate(0, n3, dArrayArray, dArray8[0]);
                }
                n3 = 2 * n2 - this.mudif + 3;
                for (int i = 0; i < n3; ++i) {
                    int n4;
                    int n5;
                    int n6 = i / 2;
                    d6 = FastMath.pow(0.5 * (double)this.sequence[n6], i);
                    int n7 = dArrayArray3[n6].length / 2;
                    for (n5 = 0; n5 < dArray.length; ++n5) {
                        dArray8[i + 1][n5] = d6 * dArrayArray3[n6][n7 + i][n5];
                    }
                    for (n5 = 1; n5 <= n2 - n6; ++n5) {
                        d6 = FastMath.pow(0.5 * (double)this.sequence[n5 + n6], i);
                        n7 = dArrayArray3[n6 + n5].length / 2;
                        for (n4 = 0; n4 < dArray.length; ++n4) {
                            dArrayArray[n5 - 1][n4] = d6 * dArrayArray3[n6 + n5][n7 + i][n4];
                        }
                        this.extrapolate(n6, n5, dArrayArray, dArray8[i + 1]);
                    }
                    n5 = 0;
                    while (n5 < dArray.length) {
                        double[] dArray10 = dArray8[i + 1];
                        int n8 = n5++;
                        dArray10[n8] = dArray10[n8] * this.stepSize;
                    }
                    for (n5 = (i + 1) / 2; n5 <= n2; ++n5) {
                        for (n4 = dArrayArray3[n5].length - 1; n4 >= 2 * (i + 1); --n4) {
                            for (int j = 0; j < dArray.length; ++j) {
                                double[] dArray11 = dArrayArray3[n5][n4];
                                int n9 = j;
                                dArray11[n9] = dArray11[n9] - dArrayArray3[n5][n4 - 2][j];
                            }
                        }
                    }
                }
                if (n3 >= 0) {
                    GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator2 = graggBulirschStoerStepInterpolator;
                    graggBulirschStoerStepInterpolator2.computeCoefficients(n3, this.stepSize);
                    if (this.useInterpolationError) {
                        double d14 = graggBulirschStoerStepInterpolator2.estimateError(dArray9);
                        d13 = FastMath.abs(this.stepSize / FastMath.max(FastMath.pow(d14, 1.0 / (double)(n3 + 4)), 0.01));
                        if (d14 > 10.0) {
                            d4 = d13;
                            bl6 = true;
                        }
                    }
                }
            }
            if (!bl6) {
                int n10;
                graggBulirschStoerStepInterpolator.storeTime(this.stepStart + this.stepSize);
                this.stepStart = this.acceptStep(graggBulirschStoerStepInterpolator, dArray4, dArray7, d);
                graggBulirschStoerStepInterpolator.storeTime(this.stepStart);
                System.arraycopy(dArray4, 0, dArray2, 0, dArray.length);
                System.arraycopy(dArray7, 0, dArray3, 0, dArray.length);
                bl5 = true;
                if (n2 == 1) {
                    n10 = 2;
                    if (bl2) {
                        n10 = 1;
                    }
                } else if (n2 <= n) {
                    n10 = n2;
                    if (this.costPerTimeUnit[n2 - 1] < this.orderControl1 * this.costPerTimeUnit[n2]) {
                        n10 = n2 - 1;
                    } else if (this.costPerTimeUnit[n2] < this.orderControl2 * this.costPerTimeUnit[n2 - 1]) {
                        n10 = FastMath.min(n2 + 1, this.sequence.length - 2);
                    }
                } else {
                    n10 = n2 - 1;
                    if (n2 > 2 && this.costPerTimeUnit[n2 - 2] < this.orderControl1 * this.costPerTimeUnit[n2 - 1]) {
                        n10 = n2 - 2;
                    }
                    if (this.costPerTimeUnit[n2] < this.orderControl2 * this.costPerTimeUnit[n10]) {
                        n10 = FastMath.min(n2, this.sequence.length - 2);
                    }
                }
                if (bl2) {
                    n = FastMath.min(n10, n2);
                    d4 = FastMath.min(FastMath.abs(this.stepSize), this.optimalStep[n]);
                } else {
                    d4 = n10 <= n2 ? this.optimalStep[n10] : (n2 < n && this.costPerTimeUnit[n2] < this.orderControl2 * this.costPerTimeUnit[n2 - 1] ? this.filterStep(this.optimalStep[n2] * (double)this.costPerStep[n10 + 1] / (double)this.costPerStep[n2], bl, false) : this.filterStep(this.optimalStep[n2] * (double)this.costPerStep[n10] / (double)this.costPerStep[n2], bl, false));
                    n = n10;
                }
                bl4 = true;
            }
            d4 = FastMath.min(d4, d13);
            if (!bl) {
                d4 = -d4;
            }
            bl3 = false;
            if (bl6) {
                this.isLastStep = false;
                bl2 = true;
                continue;
            }
            bl2 = false;
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.resetInternalState();
    }
}

