/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.HighamHall54FieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighamHall54FieldIntegrator<T extends RealFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    private static final String METHOD_NAME = "Higham-Hall 5(4)";
    private final T[] e;

    public HighamHall54FieldIntegrator(Field<T> field, double d, double d2, double d3, double d4) {
        super(field, METHOD_NAME, -1, d, d2, d3, d4);
        this.e = (RealFieldElement[])MathArrays.buildArray(field, 7);
        this.e[0] = this.fraction(-1, 20);
        this.e[1] = (RealFieldElement)field.getZero();
        this.e[2] = this.fraction(81, 160);
        this.e[3] = this.fraction(-6, 5);
        this.e[4] = this.fraction(25, 32);
        this.e[5] = this.fraction(1, 16);
        this.e[6] = this.fraction(-1, 10);
    }

    public HighamHall54FieldIntegrator(Field<T> field, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, -1, d, d2, dArray, dArray2);
        this.e = (RealFieldElement[])MathArrays.buildArray(field, 7);
        this.e[0] = this.fraction(-1, 20);
        this.e[1] = (RealFieldElement)field.getZero();
        this.e[2] = this.fraction(81, 160);
        this.e[3] = this.fraction(-6, 5);
        this.e[4] = this.fraction(25, 32);
        this.e[5] = this.fraction(1, 16);
        this.e[6] = this.fraction(-1, 10);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 6);
        realFieldElementArray[0] = this.fraction(2, 9);
        realFieldElementArray[1] = this.fraction(1, 3);
        realFieldElementArray[2] = this.fraction(1, 2);
        realFieldElementArray[3] = this.fraction(3, 5);
        realFieldElementArray[4] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray[5] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 6, -1);
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            realFieldElementArray[i] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i + 1);
        }
        realFieldElementArray[0][0] = this.fraction(2, 9);
        realFieldElementArray[1][0] = this.fraction(1, 12);
        realFieldElementArray[1][1] = this.fraction(1, 4);
        realFieldElementArray[2][0] = this.fraction(1, 8);
        realFieldElementArray[2][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2][2] = this.fraction(3, 8);
        realFieldElementArray[3][0] = this.fraction(91, 500);
        realFieldElementArray[3][1] = this.fraction(-27, 100);
        realFieldElementArray[3][2] = this.fraction(78, 125);
        realFieldElementArray[3][3] = this.fraction(8, 125);
        realFieldElementArray[4][0] = this.fraction(-11, 20);
        realFieldElementArray[4][1] = this.fraction(27, 20);
        realFieldElementArray[4][2] = this.fraction(12, 5);
        realFieldElementArray[4][3] = this.fraction(-36, 5);
        realFieldElementArray[4][4] = this.fraction(5, 1);
        realFieldElementArray[5][0] = this.fraction(1, 12);
        realFieldElementArray[5][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][2] = this.fraction(27, 32);
        realFieldElementArray[5][3] = this.fraction(-4, 3);
        realFieldElementArray[5][4] = this.fraction(125, 96);
        realFieldElementArray[5][5] = this.fraction(5, 48);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 7);
        realFieldElementArray[0] = this.fraction(1, 12);
        realFieldElementArray[1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2] = this.fraction(27, 32);
        realFieldElementArray[3] = this.fraction(-4, 3);
        realFieldElementArray[4] = this.fraction(125, 96);
        realFieldElementArray[5] = this.fraction(5, 48);
        realFieldElementArray[6] = (RealFieldElement)this.getField().getZero();
        return realFieldElementArray;
    }

    @Override
    protected HighamHall54FieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new HighamHall54FieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected T estimateError(T[][] TArray, T[] TArray2, T[] TArray3, T realFieldElement) {
        RealFieldElement realFieldElement2 = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < this.mainSetDimension; ++i) {
            RealFieldElement realFieldElement3 = (RealFieldElement)TArray[0][i].multiply(this.e[0]);
            for (int j = 1; j < this.e.length; ++j) {
                realFieldElement3 = (RealFieldElement)realFieldElement3.add(TArray[j][i].multiply(this.e[j]));
            }
            RealFieldElement realFieldElement4 = MathUtils.max((RealFieldElement)TArray2[i].abs(), (RealFieldElement)TArray3[i].abs());
            RealFieldElement realFieldElement5 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
            RealFieldElement realFieldElement6 = realFieldElement.multiply((RealFieldElement)realFieldElement3).divide(realFieldElement5);
            realFieldElement2 = realFieldElement2.add(realFieldElement6.multiply(realFieldElement6));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement2.divide(this.mainSetDimension)).sqrt());
    }
}

