/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MidpointFieldStepInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStepInterpolator<T> {
    MidpointFieldStepInterpolator(Field<T> field, boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        super(field, bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
    }

    @Override
    protected MidpointFieldStepInterpolator<T> create(Field<T> field, boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new MidpointFieldStepInterpolator(field, bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> fieldEquationsMapper, T t, T n, T t2, T n2) {
        RealFieldElement[] realFieldElementArray;
        RealFieldElement[] realFieldElementArray2;
        RealFieldElement realFieldElement = (RealFieldElement)n.multiply((int)2);
        RealFieldElement realFieldElement2 = ((RealFieldElement)t.getField().getOne()).subtract(realFieldElement);
        if (this.getGlobalPreviousState() != null && n.getReal() <= 0.5) {
            RealFieldElement realFieldElement3 = (RealFieldElement)n.multiply(n2);
            RealFieldElement realFieldElement4 = (RealFieldElement)n.multiply(t2);
            realFieldElementArray2 = this.previousStateLinearCombination(new RealFieldElement[]{realFieldElement3, realFieldElement4});
            realFieldElementArray = this.derivativeLinearCombination(new RealFieldElement[]{realFieldElement2, realFieldElement});
        } else {
            RealFieldElement realFieldElement5 = (RealFieldElement)n2.multiply(n);
            RealFieldElement realFieldElement6 = (RealFieldElement)((RealFieldElement)n2.multiply(n.add(1.0))).negate();
            realFieldElementArray2 = this.currentStateLinearCombination(new RealFieldElement[]{realFieldElement5, realFieldElement6});
            realFieldElementArray = this.derivativeLinearCombination(new RealFieldElement[]{realFieldElement2, realFieldElement});
        }
        return new FieldODEStateAndDerivative(t, realFieldElementArray2, realFieldElementArray);
    }
}

