/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.AbstractFieldIntegrator;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import org.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends AbstractFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final T[] c = this.getC();
    private final T[][] a = this.getA();
    private final T[] b = this.getB();
    private final T step;

    protected RungeKuttaFieldIntegrator(Field<T> field, String string, T t) {
        super(field, string);
        this.step = (RealFieldElement)t.abs();
    }

    protected T fraction(int n, int n2) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(n)).divide(n2));
    }

    protected abstract RungeKuttaFieldStepInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        this.setStepStart(this.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        int n = this.c.length + 1;
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        RealFieldElement[][] realFieldElementArray3 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n, -1);
        RealFieldElement[] realFieldElementArray4 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
        if (bl) {
            if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.step)).subtract(t)).getReal() >= 0.0) {
                this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
            } else {
                this.setStepSize(this.step);
            }
        } else if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().subtract(this.step)).subtract(t)).getReal() <= 0.0) {
            this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
        } else {
            this.setStepSize((RealFieldElement)this.step.negate());
        }
        this.setIsLastStep(false);
        do {
            boolean bl2;
            Object object2;
            int n2;
            realFieldElementArray2 = fieldExpandableODE.getMapper().mapState(this.getStepStart());
            realFieldElementArray3[0] = fieldExpandableODE.getMapper().mapDerivative(this.getStepStart());
            for (n2 = 1; n2 < n; ++n2) {
                for (int i = 0; i < realFieldElementArray.length; ++i) {
                    object2 = (RealFieldElement)realFieldElementArray3[0][i].multiply(this.a[n2 - 1][0]);
                    for (int j = 1; j < n2; ++j) {
                        object2 = (RealFieldElement)object2.add(realFieldElementArray3[j][i].multiply(this.a[n2 - 1][j]));
                    }
                    realFieldElementArray4[i] = (RealFieldElement)realFieldElementArray2[i].add(this.getStepSize().multiply((Object)object2));
                }
                realFieldElementArray3[n2] = this.computeDerivatives((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize().multiply(this.c[n2 - 1])), realFieldElementArray4);
            }
            for (n2 = 0; n2 < realFieldElementArray.length; ++n2) {
                RealFieldElement realFieldElement = (RealFieldElement)realFieldElementArray3[0][n2].multiply(this.b[0]);
                for (int i = 1; i < n; ++i) {
                    realFieldElement = (RealFieldElement)realFieldElement.add(realFieldElementArray3[i][n2].multiply(this.b[i]));
                }
                realFieldElementArray4[n2] = realFieldElementArray2[n2].add(this.getStepSize().multiply((RealFieldElement)realFieldElement));
            }
            object = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            RealFieldElement[] realFieldElementArray5 = this.computeDerivatives((RealFieldElement)object, realFieldElementArray4);
            object2 = new FieldODEStateAndDerivative((RealFieldElement)object, realFieldElementArray4, realFieldElementArray5);
            System.arraycopy(realFieldElementArray4, 0, realFieldElementArray2, 0, realFieldElementArray.length);
            this.setStepStart(this.acceptStep(this.createInterpolator(bl, realFieldElementArray3, this.getStepStart(), (FieldODEStateAndDerivative)object2, fieldExpandableODE.getMapper()), t));
            if (this.isLastStep()) continue;
            RealFieldElement realFieldElement = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            boolean bl3 = bl ? ((RealFieldElement)realFieldElement.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)realFieldElement.subtract(t)).getReal() <= 0.0);
            if (!bl2) continue;
            this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }

    public T[] singleStep(FirstOrderFieldDifferentialEquations<T> firstOrderFieldDifferentialEquations, T t, T[] TArray, T t2) {
        int n;
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])TArray.clone();
        int n2 = this.c.length + 1;
        RealFieldElement[][] realFieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n2, -1);
        RealFieldElement[] realFieldElementArray3 = (RealFieldElement[])TArray.clone();
        RealFieldElement realFieldElement = (RealFieldElement)t2.subtract(t);
        realFieldElementArray2[0] = firstOrderFieldDifferentialEquations.computeDerivatives((RealFieldElement)t, realFieldElementArray);
        for (n = 1; n < n2; ++n) {
            for (int i = 0; i < TArray.length; ++i) {
                RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElementArray2[0][i].multiply(this.a[n - 1][0]);
                for (int j = 1; j < n; ++j) {
                    realFieldElement2 = (RealFieldElement)realFieldElement2.add(realFieldElementArray2[j][i].multiply(this.a[n - 1][j]));
                }
                realFieldElementArray3[i] = realFieldElementArray[i].add(realFieldElement.multiply(realFieldElement2));
            }
            realFieldElementArray2[n] = firstOrderFieldDifferentialEquations.computeDerivatives((RealFieldElement)t.add(realFieldElement.multiply(this.c[n - 1])), realFieldElementArray3);
        }
        for (n = 0; n < TArray.length; ++n) {
            RealFieldElement realFieldElement3 = (RealFieldElement)realFieldElementArray2[0][n].multiply(this.b[0]);
            for (int i = 1; i < n2; ++i) {
                realFieldElement3 = (RealFieldElement)realFieldElement3.add(realFieldElementArray2[i][n].multiply(this.b[i]));
            }
            realFieldElementArray[n] = realFieldElementArray[n].add(realFieldElement.multiply(realFieldElement3));
        }
        return realFieldElementArray;
    }
}

