/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String string, double[] dArray, double[][] dArray2, double[] dArray3, RungeKuttaStepInterpolator rungeKuttaStepInterpolator, double d) {
        super(string);
        this.c = dArray;
        this.a = dArray2;
        this.b = dArray3;
        this.prototype = rungeKuttaStepInterpolator;
        this.step = FastMath.abs(d);
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d) {
        this.sanityChecks(expandableStatefulODE, d);
        this.setEquations(expandableStatefulODE);
        boolean bl = d > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        int n = this.c.length + 1;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[dArray.length];
        }
        double[] dArray3 = (double[])dArray.clone();
        double[] dArray4 = new double[dArray.length];
        RungeKuttaStepInterpolator rungeKuttaStepInterpolator = (RungeKuttaStepInterpolator)this.prototype.copy();
        rungeKuttaStepInterpolator.reinitialize(this, dArray3, dArrayArray, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        rungeKuttaStepInterpolator.storeTime(expandableStatefulODE.getTime());
        this.stepStart = expandableStatefulODE.getTime();
        this.stepSize = bl ? (this.stepStart + this.step >= d ? d - this.stepStart : this.step) : (this.stepStart - this.step <= d ? d - this.stepStart : -this.step);
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d);
        this.isLastStep = false;
        do {
            boolean bl2;
            int n2;
            rungeKuttaStepInterpolator.shift();
            this.computeDerivatives(this.stepStart, dArray2, dArrayArray[0]);
            for (n2 = 1; n2 < n; ++n2) {
                for (int i = 0; i < dArray.length; ++i) {
                    double d2 = this.a[n2 - 1][0] * dArrayArray[0][i];
                    for (int j = 1; j < n2; ++j) {
                        d2 += this.a[n2 - 1][j] * dArrayArray[j][i];
                    }
                    dArray3[i] = dArray2[i] + this.stepSize * d2;
                }
                this.computeDerivatives(this.stepStart + this.c[n2 - 1] * this.stepSize, dArray3, dArrayArray[n2]);
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                double d3 = this.b[0] * dArrayArray[0][n2];
                for (int i = 1; i < n; ++i) {
                    d3 += this.b[i] * dArrayArray[i][n2];
                }
                dArray3[n2] = dArray2[n2] + this.stepSize * d3;
            }
            rungeKuttaStepInterpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(dArray3, 0, dArray2, 0, dArray.length);
            System.arraycopy(dArrayArray[n - 1], 0, dArray4, 0, dArray.length);
            this.stepStart = this.acceptStep(rungeKuttaStepInterpolator, dArray2, dArray4, d);
            if (this.isLastStep) continue;
            rungeKuttaStepInterpolator.storeTime(this.stepStart);
            double d4 = this.stepStart + this.stepSize;
            boolean bl3 = bl ? d4 >= d : (bl2 = d4 <= d);
            if (!bl2) continue;
            this.stepSize = d - this.stepStart;
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }

    public double[] singleStep(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double d, double[] dArray, double d2) {
        int n;
        double[] dArray2 = (double[])dArray.clone();
        int n2 = this.c.length + 1;
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = new double[dArray.length];
        }
        double[] dArray3 = (double[])dArray.clone();
        double d3 = d2 - d;
        firstOrderDifferentialEquations.computeDerivatives(d, dArray2, dArrayArray[0]);
        for (n = 1; n < n2; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                double d4 = this.a[n - 1][0] * dArrayArray[0][i];
                for (int j = 1; j < n; ++j) {
                    d4 += this.a[n - 1][j] * dArrayArray[j][i];
                }
                dArray3[i] = dArray2[i] + d3 * d4;
            }
            firstOrderDifferentialEquations.computeDerivatives(d + this.c[n - 1] * d3, dArray3, dArrayArray[n]);
        }
        n = 0;
        while (n < dArray.length) {
            double d5 = this.b[0] * dArrayArray[0][n];
            for (int i = 1; i < n2; ++i) {
                d5 += this.b[i] * dArrayArray[i][n];
            }
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d3 * d5;
        }
        return dArray2;
    }
}

