/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class ThreeEighthesStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public ThreeEighthesStepInterpolator() {
    }

    ThreeEighthesStepInterpolator(ThreeEighthesStepInterpolator threeEighthesStepInterpolator) {
        super(threeEighthesStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new ThreeEighthesStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 0.75 * d;
        double d4 = d3 * (4.0 * d - 5.0) + 1.0;
        double d5 = d3 * (5.0 - 6.0 * d);
        double d6 = d3 * (2.0 * d - 1.0);
        if (this.previousState != null && d <= 0.5) {
            double d7 = d * this.h / 8.0;
            double d8 = 4.0 * d * d;
            double d9 = d7 * (8.0 - 15.0 * d + 2.0 * d8);
            double d10 = 3.0 * d7 * (5.0 * d - d8);
            double d11 = 3.0 * d7 * d;
            double d12 = d7 * (-3.0 * d + d8);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d13 = this.yDotK[0][i];
                double d14 = this.yDotK[1][i];
                double d15 = this.yDotK[2][i];
                double d16 = this.yDotK[3][i];
                this.interpolatedState[i] = this.previousState[i] + d9 * d13 + d10 * d14 + d11 * d15 + d12 * d16;
                this.interpolatedDerivatives[i] = d4 * d13 + d5 * d14 + d3 * d15 + d6 * d16;
            }
        } else {
            double d17 = d2 / 8.0;
            double d18 = 4.0 * d * d;
            double d19 = d17 * (1.0 - 7.0 * d + 2.0 * d18);
            double d20 = 3.0 * d17 * (1.0 + d - d18);
            double d21 = 3.0 * d17 * (1.0 + d);
            double d22 = d17 * (1.0 + d + d18);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d23 = this.yDotK[0][i];
                double d24 = this.yDotK[1][i];
                double d25 = this.yDotK[2][i];
                double d26 = this.yDotK[3][i];
                this.interpolatedState[i] = this.currentState[i] - d19 * d23 - d20 * d24 - d21 * d25 - d22 * d26;
                this.interpolatedDerivatives[i] = d4 * d23 + d5 * d24 + d3 * d25 + d6 * d26;
            }
        }
    }
}

