/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class NordsieckStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = -7179861704951334960L;
    protected double[] stateVariation;
    private double scalingH;
    private double referenceTime;
    private double[] scaled;
    private Array2DRowRealMatrix nordsieck;

    public NordsieckStepInterpolator() {
    }

    public NordsieckStepInterpolator(NordsieckStepInterpolator nordsieckStepInterpolator) {
        super(nordsieckStepInterpolator);
        this.scalingH = nordsieckStepInterpolator.scalingH;
        this.referenceTime = nordsieckStepInterpolator.referenceTime;
        if (nordsieckStepInterpolator.scaled != null) {
            this.scaled = (double[])nordsieckStepInterpolator.scaled.clone();
        }
        if (nordsieckStepInterpolator.nordsieck != null) {
            this.nordsieck = new Array2DRowRealMatrix(nordsieckStepInterpolator.nordsieck.getDataRef(), true);
        }
        if (nordsieckStepInterpolator.stateVariation != null) {
            this.stateVariation = (double[])nordsieckStepInterpolator.stateVariation.clone();
        }
    }

    protected StepInterpolator doCopy() {
        return new NordsieckStepInterpolator(this);
    }

    public void reinitialize(double[] dArray, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        super.reinitialize(dArray, bl, equationsMapper, equationsMapperArray);
        this.stateVariation = new double[dArray.length];
    }

    public void reinitialize(double d, double d2, double[] dArray, Array2DRowRealMatrix array2DRowRealMatrix) {
        this.referenceTime = d;
        this.scalingH = d2;
        this.scaled = dArray;
        this.nordsieck = array2DRowRealMatrix;
        this.setInterpolatedTime(this.getInterpolatedTime());
    }

    public void rescale(double d) {
        double d2 = d / this.scalingH;
        int n = 0;
        while (n < this.scaled.length) {
            int n2 = n++;
            this.scaled[n2] = this.scaled[n2] * d2;
        }
        double[][] dArray = this.nordsieck.getDataRef();
        double d3 = d2;
        for (int i = 0; i < dArray.length; ++i) {
            d3 *= d2;
            double[] dArray2 = dArray[i];
            int n3 = 0;
            while (n3 < dArray2.length) {
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] * d3;
            }
        }
        this.scalingH = d;
    }

    public double[] getInterpolatedStateVariation() {
        this.getInterpolatedState();
        return this.stateVariation;
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        int n;
        double d3 = this.interpolatedTime - this.referenceTime;
        double d4 = d3 / this.scalingH;
        Arrays.fill(this.stateVariation, 0.0);
        Arrays.fill(this.interpolatedDerivatives, 0.0);
        double[][] dArray = this.nordsieck.getDataRef();
        for (n = dArray.length - 1; n >= 0; --n) {
            int n2 = n + 2;
            double[] dArray2 = dArray[n];
            double d5 = FastMath.pow(d4, n2);
            int n3 = 0;
            while (n3 < dArray2.length) {
                double d6 = dArray2[n3] * d5;
                int n4 = n3;
                this.stateVariation[n4] = this.stateVariation[n4] + d6;
                int n5 = n3++;
                this.interpolatedDerivatives[n5] = this.interpolatedDerivatives[n5] + (double)n2 * d6;
            }
        }
        for (n = 0; n < this.currentState.length; ++n) {
            int n6 = n;
            this.stateVariation[n6] = this.stateVariation[n6] + this.scaled[n] * d4;
            this.interpolatedState[n] = this.currentState[n] + this.stateVariation[n];
            this.interpolatedDerivatives[n] = (this.interpolatedDerivatives[n] + this.scaled[n] * d4) / d3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n;
        this.writeBaseExternal(objectOutput);
        objectOutput.writeDouble(this.scalingH);
        objectOutput.writeDouble(this.referenceTime);
        int n2 = n = this.currentState == null ? -1 : this.currentState.length;
        if (this.scaled == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeDouble(this.scaled[i]);
            }
        }
        if (this.nordsieck == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.nordsieck);
        }
    }

    public void readExternal(ObjectInput objectInput) {
        int n;
        double d = this.readBaseExternal(objectInput);
        this.scalingH = objectInput.readDouble();
        this.referenceTime = objectInput.readDouble();
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        boolean bl = objectInput.readBoolean();
        if (bl) {
            this.scaled = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.scaled[n] = objectInput.readDouble();
            }
        } else {
            this.scaled = null;
        }
        this.nordsieck = (n = objectInput.readBoolean()) != 0 ? (Array2DRowRealMatrix)objectInput.readObject() : null;
        if (bl && n != 0) {
            this.stateVariation = new double[n2];
            this.setInterpolatedTime(d);
        } else {
            this.stateVariation = null;
        }
    }
}

