/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.RealMatrix;

public class LeastSquaresConverter
implements MultivariateFunction {
    private final MultivariateVectorFunction function;
    private final double[] observations;
    private final double[] weights;
    private final RealMatrix scale;

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray) {
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = null;
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = (double[])dArray2.clone();
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray, RealMatrix realMatrix) {
        if (dArray.length != realMatrix.getColumnDimension()) {
            throw new DimensionMismatchException(dArray.length, realMatrix.getColumnDimension());
        }
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = null;
        this.scale = realMatrix.copy();
    }

    public double value(double[] dArray) {
        double[] dArray2 = this.function.value(dArray);
        if (dArray2.length != this.observations.length) {
            throw new DimensionMismatchException(dArray2.length, this.observations.length);
        }
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] - this.observations[i];
        }
        double d = 0.0;
        if (this.weights != null) {
            for (int i = 0; i < dArray2.length; ++i) {
                double d2 = dArray2[i];
                d += this.weights[i] * d2 * d2;
            }
        } else if (this.scale != null) {
            for (double d3 : this.scale.operate(dArray2)) {
                d += d3 * d3;
            }
        } else {
            for (double d4 : dArray2) {
                d += d4 * d4;
            }
        }
        return d;
    }
}

