/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.gradient;

import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.GradientMultivariateOptimizer;
import org.apache.commons.math3.optim.nonlinear.scalar.LineSearch;
import org.apache.commons.math3.optim.nonlinear.scalar.gradient.Preconditioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonLinearConjugateGradientOptimizer
extends GradientMultivariateOptimizer {
    private final Formula updateFormula;
    private final Preconditioner preconditioner;
    private final LineSearch line;

    public NonLinearConjugateGradientOptimizer(Formula formula, ConvergenceChecker<PointValuePair> convergenceChecker) {
        this(formula, convergenceChecker, 1.0E-8, 1.0E-8, 1.0E-8, new IdentityPreconditioner());
    }

    @Deprecated
    public NonLinearConjugateGradientOptimizer(Formula formula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver) {
        this(formula, convergenceChecker, univariateSolver, new IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(Formula formula, ConvergenceChecker<PointValuePair> convergenceChecker, double d, double d2, double d3) {
        this(formula, convergenceChecker, d, d2, d3, new IdentityPreconditioner());
    }

    @Deprecated
    public NonLinearConjugateGradientOptimizer(Formula formula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver, Preconditioner preconditioner) {
        this(formula, convergenceChecker, univariateSolver.getRelativeAccuracy(), univariateSolver.getAbsoluteAccuracy(), univariateSolver.getAbsoluteAccuracy(), preconditioner);
    }

    public NonLinearConjugateGradientOptimizer(Formula formula, ConvergenceChecker<PointValuePair> convergenceChecker, double d, double d2, double d3, Preconditioner preconditioner) {
        super(convergenceChecker);
        this.updateFormula = formula;
        this.preconditioner = preconditioner;
        this.line = new LineSearch(this, d, d2, d3);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected PointValuePair doOptimize() {
        var1_1 = this.getConvergenceChecker();
        var2_2 = this.getStartPoint();
        var3_3 = this.getGoalType();
        var4_4 = var2_2.length;
        var5_5 = this.computeObjectiveGradient(var2_2);
        if (var3_3 == GoalType.MINIMIZE) {
            for (var6_6 = 0; var6_6 < var4_4; ++var6_6) {
                var5_5[var6_6] = -var5_5[var6_6];
            }
        }
        var6_7 = this.preconditioner.precondition(var2_2, var5_5);
        var7_8 = (double[])var6_7.clone();
        var8_9 = 0.0;
        for (var10_10 = 0; var10_10 < var4_4; ++var10_10) {
            var8_9 += var5_5[var10_10] * var7_8[var10_10];
        }
        var10_11 = null;
        block6: while (true) {
            this.incrementIterationCount();
            var11_12 = this.computeObjectiveValue(var2_2);
            var13_13 = var10_11;
            var10_11 = new PointValuePair(var2_2, var11_12);
            if (var13_13 != null && var1_1.converged(this.getIterations(), var13_13, var10_11)) {
                return var10_11;
            }
            var14_14 = this.line.search(var2_2, var7_8).getPoint();
            for (var16_16 = 0; var16_16 < var2_2.length; ++var16_16) {
                v0 = var16_16;
                var2_2[v0] = var2_2[v0] + var14_14 * var7_8[var16_16];
            }
            var5_5 = this.computeObjectiveGradient(var2_2);
            if (var3_3 == GoalType.MINIMIZE) {
                for (var16_16 = 0; var16_16 < var4_4; ++var16_16) {
                    var5_5[var16_16] = -var5_5[var16_16];
                }
            }
            var16_15 = var8_9;
            var18_17 = this.preconditioner.precondition(var2_2, var5_5);
            var8_9 = 0.0;
            for (var19_19 = 0; var19_19 < var4_4; ++var19_19) {
                var8_9 += var5_5[var19_19] * var18_17[var19_19];
            }
            switch (1.$SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula[this.updateFormula.ordinal()]) {
                case 1: {
                    var19_18 = var8_9 / var16_15;
                    break;
                }
                case 2: {
                    var21_20 = 0.0;
                    for (var23_22 = 0; var23_22 < var5_5.length; ++var23_22) {
                        var21_20 += var5_5[var23_22] * var6_7[var23_22];
                    }
                    var19_18 = (var8_9 - var21_20) / var16_15;
                    break;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            var6_7 = var18_17;
            if (this.getIterations() % var4_4 == 0 || var19_18 < 0.0) {
                var7_8 = (double[])var6_7.clone();
                continue;
            }
            var21_21 = 0;
            while (true) {
                if (var21_21 < var4_4) ** break;
                continue block6;
                var7_8[var21_21] = var6_7[var21_21] + var19_18 * var7_8[var21_21];
                ++var21_21;
            }
            break;
        }
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        this.checkParameters();
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula;

        static {
            $SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula = new int[Formula.values().length];
            try {
                1.$SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula[Formula.FLETCHER_REEVES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula[Formula.POLAK_RIBIERE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class IdentityPreconditioner
    implements Preconditioner {
        public double[] precondition(double[] dArray, double[] dArray2) {
            return (double[])dArray2.clone();
        }
    }

    @Deprecated
    public static class BracketingStep
    implements OptimizationData {
        private final double initialStep;

        public BracketingStep(double d) {
            this.initialStep = d;
        }

        public double getBracketingStep() {
            return this.initialStep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Formula {
        FLETCHER_REEVES,
        POLAK_RIBIERE;

    }
}

