/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.AbstractSimplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDirectionalSimplex
extends AbstractSimplex {
    private static final double DEFAULT_KHI = 2.0;
    private static final double DEFAULT_GAMMA = 0.5;
    private final double khi;
    private final double gamma;

    public MultiDirectionalSimplex(int n) {
        this(n, 1.0);
    }

    public MultiDirectionalSimplex(int n, double d) {
        this(n, d, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(int n, double d, double d2) {
        this(n, 1.0, d, d2);
    }

    public MultiDirectionalSimplex(int n, double d, double d2, double d3) {
        super(n, d);
        this.khi = d2;
        this.gamma = d3;
    }

    public MultiDirectionalSimplex(double[] dArray) {
        this(dArray, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(double[] dArray, double d, double d2) {
        super(dArray);
        this.khi = d;
        this.gamma = d2;
    }

    public MultiDirectionalSimplex(double[][] dArray) {
        this(dArray, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(double[][] dArray, double d, double d2) {
        super(dArray);
        this.khi = d;
        this.gamma = d2;
    }

    @Override
    public void iterate(MultivariateFunction multivariateFunction, Comparator<PointValuePair> comparator) {
        PointValuePair[] pointValuePairArray = this.getPoints();
        PointValuePair pointValuePair = pointValuePairArray[0];
        PointValuePair pointValuePair2 = this.evaluateNewSimplex(multivariateFunction, pointValuePairArray, 1.0, comparator);
        if (comparator.compare(pointValuePair2, pointValuePair) < 0) {
            PointValuePair[] pointValuePairArray2 = this.getPoints();
            PointValuePair pointValuePair3 = this.evaluateNewSimplex(multivariateFunction, pointValuePairArray, this.khi, comparator);
            if (comparator.compare(pointValuePair2, pointValuePair3) <= 0) {
                this.setPoints(pointValuePairArray2);
            }
            return;
        }
        this.evaluateNewSimplex(multivariateFunction, pointValuePairArray, this.gamma, comparator);
    }

    private PointValuePair evaluateNewSimplex(MultivariateFunction multivariateFunction, PointValuePair[] pointValuePairArray, double d, Comparator<PointValuePair> comparator) {
        double[] dArray = pointValuePairArray[0].getPointRef();
        this.setPoint(0, pointValuePairArray[0]);
        int n = this.getDimension();
        for (int i = 1; i < this.getSize(); ++i) {
            double[] dArray2 = pointValuePairArray[i].getPointRef();
            double[] dArray3 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray3[j] = dArray[j] + d * (dArray[j] - dArray2[j]);
            }
            this.setPoint(i, new PointValuePair(dArray3, Double.NaN, false));
        }
        this.evaluate(multivariateFunction, comparator);
        return this.getPoint(0);
    }
}

