/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.AbstractSimplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NelderMeadSimplex
extends AbstractSimplex {
    private static final double DEFAULT_RHO = 1.0;
    private static final double DEFAULT_KHI = 2.0;
    private static final double DEFAULT_GAMMA = 0.5;
    private static final double DEFAULT_SIGMA = 0.5;
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMeadSimplex(int n) {
        this(n, 1.0);
    }

    public NelderMeadSimplex(int n, double d) {
        this(n, d, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(int n, double d, double d2, double d3, double d4, double d5) {
        super(n, d);
        this.rho = d2;
        this.khi = d3;
        this.gamma = d4;
        this.sigma = d5;
    }

    public NelderMeadSimplex(int n, double d, double d2, double d3, double d4) {
        this(n, 1.0, d, d2, d3, d4);
    }

    public NelderMeadSimplex(double[] dArray) {
        this(dArray, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[] dArray, double d, double d2, double d3, double d4) {
        super(dArray);
        this.rho = d;
        this.khi = d2;
        this.gamma = d3;
        this.sigma = d4;
    }

    public NelderMeadSimplex(double[][] dArray) {
        this(dArray, 1.0, 2.0, 0.5, 0.5);
    }

    public NelderMeadSimplex(double[][] dArray, double d, double d2, double d3, double d4) {
        super(dArray);
        this.rho = d;
        this.khi = d2;
        this.gamma = d3;
        this.sigma = d4;
    }

    @Override
    public void iterate(MultivariateFunction multivariateFunction, Comparator<PointValuePair> comparator) {
        int n;
        int n2 = this.getDimension();
        PointValuePair pointValuePair = this.getPoint(0);
        PointValuePair pointValuePair2 = this.getPoint(n2 - 1);
        PointValuePair pointValuePair3 = this.getPoint(n2);
        double[] dArray = pointValuePair3.getPointRef();
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = this.getPoint(i).getPointRef();
            for (n = 0; n < n2; ++n) {
                int n3 = n;
                dArray2[n3] = dArray2[n3] + dArray3[n];
            }
        }
        double d = 1.0 / (double)n2;
        n = 0;
        while (n < n2) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] * d;
        }
        double[] dArray4 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = dArray2[i] + this.rho * (dArray2[i] - dArray[i]);
        }
        PointValuePair pointValuePair4 = new PointValuePair(dArray4, multivariateFunction.value(dArray4), false);
        if (comparator.compare(pointValuePair, pointValuePair4) <= 0 && comparator.compare(pointValuePair4, pointValuePair2) < 0) {
            this.replaceWorstPoint(pointValuePair4, comparator);
        } else if (comparator.compare(pointValuePair4, pointValuePair) < 0) {
            double[] dArray5 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray5[i] = dArray2[i] + this.khi * (dArray4[i] - dArray2[i]);
            }
            PointValuePair pointValuePair5 = new PointValuePair(dArray5, multivariateFunction.value(dArray5), false);
            if (comparator.compare(pointValuePair5, pointValuePair4) < 0) {
                this.replaceWorstPoint(pointValuePair5, comparator);
            } else {
                this.replaceWorstPoint(pointValuePair4, comparator);
            }
        } else {
            PointValuePair pointValuePair6;
            double[] dArray6;
            if (comparator.compare(pointValuePair4, pointValuePair3) < 0) {
                dArray6 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray6[i] = dArray2[i] + this.gamma * (dArray4[i] - dArray2[i]);
                }
                pointValuePair6 = new PointValuePair(dArray6, multivariateFunction.value(dArray6), false);
                if (comparator.compare(pointValuePair6, pointValuePair4) <= 0) {
                    this.replaceWorstPoint(pointValuePair6, comparator);
                    return;
                }
            } else {
                dArray6 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray6[i] = dArray2[i] - this.gamma * (dArray2[i] - dArray[i]);
                }
                pointValuePair6 = new PointValuePair(dArray6, multivariateFunction.value(dArray6), false);
                if (comparator.compare(pointValuePair6, pointValuePair3) < 0) {
                    this.replaceWorstPoint(pointValuePair6, comparator);
                    return;
                }
            }
            dArray6 = this.getPoint(0).getPointRef();
            for (int i = 1; i <= n2; ++i) {
                double[] dArray7 = this.getPoint(i).getPoint();
                for (int j = 0; j < n2; ++j) {
                    dArray7[j] = dArray6[j] + this.sigma * (dArray7[j] - dArray6[j]);
                }
                this.setPoint(i, new PointValuePair(dArray7, Double.NaN, false));
            }
            this.evaluate(multivariateFunction, comparator);
        }
    }
}

