/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.AbstractSimplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplexOptimizer
extends MultivariateOptimizer {
    private AbstractSimplex simplex;

    public SimplexOptimizer(ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    public SimplexOptimizer(double d, double d2) {
        this(new SimpleValueChecker(d, d2));
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        MultivariateFunction multivariateFunction = new MultivariateFunction(){

            public double value(double[] dArray) {
                return SimplexOptimizer.this.computeObjectiveValue(dArray);
            }
        };
        final boolean bl = this.getGoalType() == GoalType.MINIMIZE;
        Comparator<PointValuePair> comparator = new Comparator<PointValuePair>(){

            @Override
            public int compare(PointValuePair pointValuePair, PointValuePair pointValuePair2) {
                double d = (Double)pointValuePair.getValue();
                double d2 = (Double)pointValuePair2.getValue();
                return bl ? Double.compare(d, d2) : Double.compare(d2, d);
            }
        };
        this.simplex.build(this.getStartPoint());
        this.simplex.evaluate(multivariateFunction, comparator);
        PointValuePair[] pointValuePairArray = null;
        int n = 0;
        ConvergenceChecker<PointValuePair> convergenceChecker = this.getConvergenceChecker();
        while (true) {
            if (this.getIterations() > 0) {
                boolean bl2 = true;
                for (int i = 0; i < this.simplex.getSize(); ++i) {
                    PointValuePair pointValuePair = pointValuePairArray[i];
                    bl2 = bl2 && convergenceChecker.converged(n, pointValuePair, this.simplex.getPoint(i));
                }
                if (bl2) {
                    return this.simplex.getPoint(0);
                }
            }
            pointValuePairArray = this.simplex.getPoints();
            this.simplex.iterate(multivariateFunction, comparator);
            this.incrementIterationCount();
        }
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (!(optimizationData instanceof AbstractSimplex)) continue;
            this.simplex = (AbstractSimplex)optimizationData;
            break;
        }
    }

    private void checkParameters() {
        if (this.simplex == null) {
            throw new NullArgumentException();
        }
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }
}

