/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.BaseMultiStartMultivariateOptimizer;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MultiStartMultivariateVectorOptimizer
extends BaseMultiStartMultivariateOptimizer<PointVectorValuePair> {
    private final MultivariateVectorOptimizer optimizer;
    private final List<PointVectorValuePair> optima = new ArrayList<PointVectorValuePair>();

    public MultiStartMultivariateVectorOptimizer(MultivariateVectorOptimizer multivariateVectorOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        super(multivariateVectorOptimizer, n, randomVectorGenerator);
        this.optimizer = multivariateVectorOptimizer;
    }

    public PointVectorValuePair[] getOptima() {
        Collections.sort(this.optima, this.getPairComparator());
        return this.optima.toArray(new PointVectorValuePair[0]);
    }

    @Override
    protected void store(PointVectorValuePair pointVectorValuePair) {
        this.optima.add(pointVectorValuePair);
    }

    @Override
    protected void clear() {
        this.optima.clear();
    }

    private Comparator<PointVectorValuePair> getPairComparator() {
        return new Comparator<PointVectorValuePair>(){
            private final RealVector target;
            private final RealMatrix weight;
            {
                this.target = new ArrayRealVector(MultiStartMultivariateVectorOptimizer.this.optimizer.getTarget(), false);
                this.weight = MultiStartMultivariateVectorOptimizer.this.optimizer.getWeight();
            }

            @Override
            public int compare(PointVectorValuePair pointVectorValuePair, PointVectorValuePair pointVectorValuePair2) {
                if (pointVectorValuePair == null) {
                    return pointVectorValuePair2 == null ? 0 : 1;
                }
                if (pointVectorValuePair2 == null) {
                    return -1;
                }
                return Double.compare(this.weightedResidual(pointVectorValuePair), this.weightedResidual(pointVectorValuePair2));
            }

            private double weightedResidual(PointVectorValuePair pointVectorValuePair) {
                ArrayRealVector arrayRealVector = new ArrayRealVector(pointVectorValuePair.getValueRef(), false);
                RealVector realVector = this.target.subtract(arrayRealVector);
                return realVector.dotProduct(this.weight.operate(realVector));
            }
        };
    }
}

