/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.univariate;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.random.RandomGenerator;

public class MultiStartUnivariateOptimizer
extends UnivariateOptimizer {
    private final UnivariateOptimizer optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomGenerator generator;
    private UnivariatePointValuePair[] optima;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int searchIntervalIndex = -1;

    public MultiStartUnivariateOptimizer(UnivariateOptimizer univariateOptimizer, int n, RandomGenerator randomGenerator) {
        super(univariateOptimizer.getConvergenceChecker());
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = univariateOptimizer;
        this.starts = n;
        this.generator = randomGenerator;
    }

    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public UnivariatePointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException(LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (UnivariatePointValuePair[])this.optima.clone();
    }

    public UnivariatePointValuePair optimize(OptimizationData ... optimizationDataArray) {
        this.optimData = optimizationDataArray;
        return super.optimize(optimizationDataArray);
    }

    protected UnivariatePointValuePair doOptimize() {
        for (int i = 0; i < this.optimData.length; ++i) {
            if (this.optimData[i] instanceof MaxEval) {
                this.optimData[i] = null;
                this.maxEvalIndex = i;
                continue;
            }
            if (!(this.optimData[i] instanceof SearchInterval)) continue;
            this.optimData[i] = null;
            this.searchIntervalIndex = i;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException();
        }
        if (this.searchIntervalIndex == -1) {
            throw new MathIllegalStateException();
        }
        RuntimeException runtimeException = null;
        this.optima = new UnivariatePointValuePair[this.starts];
        this.totalEvaluations = 0;
        int n = this.getMaxEvaluations();
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = this.getStartValue();
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(n - this.totalEvaluations);
                double d4 = i == 0 ? d3 : d + this.generator.nextDouble() * (d2 - d);
                this.optimData[this.searchIntervalIndex] = new SearchInterval(d, d2, d4);
                this.optima[i] = this.optimizer.optimize(this.optimData);
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                this.optima[i] = null;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        this.sortPairs(this.getGoalType());
        if (this.optima[0] == null) {
            throw runtimeException;
        }
        return this.optima[0];
    }

    private void sortPairs(final GoalType goalType) {
        Arrays.sort(this.optima, new Comparator<UnivariatePointValuePair>(){

            @Override
            public int compare(UnivariatePointValuePair univariatePointValuePair, UnivariatePointValuePair univariatePointValuePair2) {
                if (univariatePointValuePair == null) {
                    return univariatePointValuePair2 == null ? 0 : 1;
                }
                if (univariatePointValuePair2 == null) {
                    return -1;
                }
                double d = univariatePointValuePair.getValue();
                double d2 = univariatePointValuePair2.getValue();
                return goalType == GoalType.MINIMIZE ? Double.compare(d, d2) : Double.compare(d2, d);
            }
        });
    }
}

