/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optimization.BaseMultivariateOptimizer;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BaseMultivariateMultiStartOptimizer<FUNC extends MultivariateFunction>
implements BaseMultivariateOptimizer<FUNC> {
    private final BaseMultivariateOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private PointValuePair[] optima;

    protected BaseMultivariateMultiStartOptimizer(BaseMultivariateOptimizer<FUNC> baseMultivariateOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        if (baseMultivariateOptimizer == null || randomVectorGenerator == null) {
            throw new NullArgumentException();
        }
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = baseMultivariateOptimizer;
        this.starts = n;
        this.generator = randomVectorGenerator;
    }

    public PointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException(LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (PointValuePair[])this.optima.clone();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public ConvergenceChecker<PointValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public PointValuePair optimize(int n, FUNC FUNC, GoalType goalType, double[] dArray) {
        this.maxEvaluations = n;
        RuntimeException runtimeException = null;
        this.optima = new PointValuePair[this.starts];
        this.totalEvaluations = 0;
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optima[i] = this.optimizer.optimize(n - this.totalEvaluations, FUNC, goalType, i == 0 ? dArray : this.generator.nextVector());
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                this.optima[i] = null;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        this.sortPairs(goalType);
        if (this.optima[0] == null) {
            throw runtimeException;
        }
        return this.optima[0];
    }

    private void sortPairs(final GoalType goalType) {
        Arrays.sort(this.optima, new Comparator<PointValuePair>(){

            @Override
            public int compare(PointValuePair pointValuePair, PointValuePair pointValuePair2) {
                if (pointValuePair == null) {
                    return pointValuePair2 == null ? 0 : 1;
                }
                if (pointValuePair2 == null) {
                    return -1;
                }
                double d = (Double)pointValuePair.getValue();
                double d2 = (Double)pointValuePair2.getValue();
                return goalType == GoalType.MINIMIZE ? Double.compare(d, d2) : Double.compare(d2, d);
            }
        });
    }
}

