/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optimization.BaseMultivariateOptimizer;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.InitialGuess;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimpleBounds;
import org.apache.commons.math3.optimization.SimpleValueChecker;
import org.apache.commons.math3.util.Incrementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class BaseAbstractMultivariateOptimizer<FUNC extends MultivariateFunction>
implements BaseMultivariateOptimizer<FUNC> {
    protected final Incrementor evaluations = new Incrementor();
    private ConvergenceChecker<PointValuePair> checker;
    private GoalType goal;
    private double[] start;
    private double[] lowerBound;
    private double[] upperBound;
    private MultivariateFunction function;

    @Deprecated
    protected BaseAbstractMultivariateOptimizer() {
        this(new SimpleValueChecker());
    }

    protected BaseAbstractMultivariateOptimizer(ConvergenceChecker<PointValuePair> convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public ConvergenceChecker<PointValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected double computeObjectiveValue(double[] dArray) {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return this.function.value(dArray);
    }

    @Override
    @Deprecated
    public PointValuePair optimize(int n, FUNC FUNC, GoalType goalType, double[] dArray) {
        return this.optimizeInternal(n, FUNC, goalType, new InitialGuess(dArray));
    }

    public PointValuePair optimize(int n, FUNC FUNC, GoalType goalType, OptimizationData ... optimizationDataArray) {
        return this.optimizeInternal(n, FUNC, goalType, optimizationDataArray);
    }

    @Deprecated
    protected PointValuePair optimizeInternal(int n, FUNC FUNC, GoalType goalType, double[] dArray) {
        return this.optimizeInternal(n, FUNC, goalType, new InitialGuess(dArray));
    }

    protected PointValuePair optimizeInternal(int n, FUNC FUNC, GoalType goalType, OptimizationData ... optimizationDataArray) {
        this.evaluations.setMaximalCount(n);
        this.evaluations.resetCount();
        this.function = FUNC;
        this.goal = goalType;
        this.parseOptimizationData(optimizationDataArray);
        this.checkParameters();
        return this.doOptimize();
    }

    private void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof InitialGuess) {
                this.start = ((InitialGuess)optimizationData).getInitialGuess();
                continue;
            }
            if (!(optimizationData instanceof SimpleBounds)) continue;
            SimpleBounds simpleBounds = (SimpleBounds)optimizationData;
            this.lowerBound = simpleBounds.getLower();
            this.upperBound = simpleBounds.getUpper();
        }
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    public double[] getStartPoint() {
        return this.start == null ? null : (double[])this.start.clone();
    }

    public double[] getLowerBound() {
        return this.lowerBound == null ? null : (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        return this.upperBound == null ? null : (double[])this.upperBound.clone();
    }

    protected abstract PointValuePair doOptimize();

    private void checkParameters() {
        if (this.start != null) {
            double d;
            double d2;
            int n;
            int n2 = this.start.length;
            if (this.lowerBound != null) {
                if (this.lowerBound.length != n2) {
                    throw new DimensionMismatchException(this.lowerBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d2 = this.start[n];
                    d = this.lowerBound[n];
                    if (!(d2 < d)) continue;
                    throw new NumberIsTooSmallException(d2, (Number)d, true);
                }
            }
            if (this.upperBound != null) {
                if (this.upperBound.length != n2) {
                    throw new DimensionMismatchException(this.upperBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d2 = this.start[n];
                    d = this.upperBound[n];
                    if (!(d2 > d)) continue;
                    throw new NumberIsTooLargeException(d2, (Number)d, true);
                }
            }
            if (this.lowerBound == null) {
                this.lowerBound = new double[n2];
                for (n = 0; n < n2; ++n) {
                    this.lowerBound[n] = Double.NEGATIVE_INFINITY;
                }
            }
            if (this.upperBound == null) {
                this.upperBound = new double[n2];
                for (n = 0; n < n2; ++n) {
                    this.upperBound[n] = Double.POSITIVE_INFINITY;
                }
            }
        }
    }
}

