/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import java.io.Serializable;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.MultivariateOptimizer;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateOptimizer;
import org.apache.commons.math3.optimization.univariate.BracketFinder;
import org.apache.commons.math3.optimization.univariate.BrentOptimizer;
import org.apache.commons.math3.optimization.univariate.SimpleUnivariateValueChecker;
import org.apache.commons.math3.optimization.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PowellOptimizer
extends BaseAbstractMultivariateOptimizer<MultivariateFunction>
implements MultivariateOptimizer {
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;
    private final LineSearch line;

    public PowellOptimizer(double d, double d2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        this(d, d2, FastMath.sqrt(d), FastMath.sqrt(d2), convergenceChecker);
    }

    public PowellOptimizer(double d, double d2, double d3, double d4, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        if (d < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(d, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        this.relativeThreshold = d;
        this.absoluteThreshold = d2;
        this.line = new LineSearch(d3, d4);
    }

    public PowellOptimizer(double d, double d2) {
        this(d, d2, null);
    }

    public PowellOptimizer(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, null);
    }

    @Override
    protected PointValuePair doOptimize() {
        GoalType goalType = this.getGoalType();
        double[] dArray = this.getStartPoint();
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray2[i][i] = 1.0;
        }
        ConvergenceChecker<PointValuePair> convergenceChecker = this.getConvergenceChecker();
        double[] dArray3 = dArray;
        double d = this.computeObjectiveValue(dArray3);
        double[] dArray4 = (double[])dArray3.clone();
        int n2 = 0;
        while (true) {
            Object object;
            Serializable serializable;
            Object object2;
            int n3;
            ++n2;
            double d2 = d;
            double d3 = 0.0;
            double d4 = 0.0;
            int n4 = 0;
            double d5 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                object2 = MathArrays.copyOf(dArray2[n3]);
                d3 = d;
                serializable = this.line.search(dArray3, (double[])object2);
                d = serializable.getValue();
                d5 = serializable.getPoint();
                object = this.newPointAndDirection(dArray3, (double[])object2, d5);
                dArray3 = object[0];
                if (!(d3 - d > d4)) continue;
                d4 = d3 - d;
                n4 = n3;
            }
            n3 = 2.0 * (d2 - d) <= this.relativeThreshold * (FastMath.abs(d2) + FastMath.abs(d)) + this.absoluteThreshold ? 1 : 0;
            object2 = new PointValuePair(dArray4, d2);
            serializable = new PointValuePair(dArray3, d);
            if (n3 == 0 && convergenceChecker != null) {
                n3 = convergenceChecker.converged(n2, (PointValuePair)object2, (PointValuePair)serializable) ? 1 : 0;
            }
            if (n3 != 0) {
                if (goalType == GoalType.MINIMIZE) {
                    return d < d2 ? serializable : (Object)object2;
                }
                return d > d2 ? serializable : (Object)object2;
            }
            object = new double[n];
            double[] dArray5 = new double[n];
            for (int i = 0; i < n; ++i) {
                object[i] = (double[])(dArray3[i] - dArray4[i]);
                dArray5[i] = 2.0 * dArray3[i] - dArray4[i];
            }
            dArray4 = (double[])dArray3.clone();
            d3 = this.computeObjectiveValue(dArray5);
            if (!(d2 > d3)) continue;
            double d6 = 2.0 * (d2 + d3 - 2.0 * d);
            double d7 = d2 - d - d4;
            d6 *= d7 * d7;
            d7 = d2 - d3;
            if (!((d6 -= d4 * d7 * d7) < 0.0)) continue;
            UnivariatePointValuePair univariatePointValuePair = this.line.search(dArray3, (double[])object);
            d = univariatePointValuePair.getValue();
            d5 = univariatePointValuePair.getPoint();
            double[][] dArray6 = this.newPointAndDirection(dArray3, (double[])object, d5);
            dArray3 = dArray6[0];
            int n5 = n - 1;
            dArray2[n4] = dArray2[n5];
            dArray2[n5] = dArray6[1];
        }
    }

    private double[][] newPointAndDirection(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray4[i] = dArray2[i] * d;
            dArray3[i] = dArray[i] + dArray4[i];
        }
        double[][] dArrayArray = new double[][]{dArray3, dArray4};
        return dArrayArray;
    }

    private class LineSearch
    extends BrentOptimizer {
        private static final double REL_TOL_UNUSED = 1.0E-15;
        private static final double ABS_TOL_UNUSED = Double.MIN_VALUE;
        private final BracketFinder bracket;

        LineSearch(double d, double d2) {
            super(1.0E-15, Double.MIN_VALUE, new SimpleUnivariateValueChecker(d, d2));
            this.bracket = new BracketFinder();
        }

        public UnivariatePointValuePair search(final double[] dArray, final double[] dArray2) {
            final int n = dArray.length;
            UnivariateFunction univariateFunction = new UnivariateFunction(){

                public double value(double d) {
                    double[] dArray3 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        dArray3[i] = dArray[i] + d * dArray2[i];
                    }
                    double d2 = PowellOptimizer.this.computeObjectiveValue(dArray3);
                    return d2;
                }
            };
            GoalType goalType = PowellOptimizer.this.getGoalType();
            this.bracket.search(univariateFunction, goalType, 0.0, 1.0);
            return this.optimize(Integer.MAX_VALUE, univariateFunction, goalType, this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid());
        }
    }
}

