/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.MultivariateOptimizer;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimpleValueChecker;
import org.apache.commons.math3.optimization.direct.AbstractSimplex;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SimplexOptimizer
extends BaseAbstractMultivariateOptimizer<MultivariateFunction>
implements MultivariateOptimizer {
    private AbstractSimplex simplex;

    @Deprecated
    public SimplexOptimizer() {
        this(new SimpleValueChecker());
    }

    public SimplexOptimizer(ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    public SimplexOptimizer(double d, double d2) {
        this(new SimpleValueChecker(d, d2));
    }

    @Deprecated
    public void setSimplex(AbstractSimplex abstractSimplex) {
        this.parseOptimizationData(abstractSimplex);
    }

    @Override
    protected PointValuePair optimizeInternal(int n, MultivariateFunction multivariateFunction, GoalType goalType, OptimizationData ... optimizationDataArray) {
        this.parseOptimizationData(optimizationDataArray);
        return super.optimizeInternal(n, multivariateFunction, goalType, optimizationDataArray);
    }

    private void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (!(optimizationData instanceof AbstractSimplex)) continue;
            this.simplex = (AbstractSimplex)optimizationData;
        }
    }

    @Override
    protected PointValuePair doOptimize() {
        if (this.simplex == null) {
            throw new NullArgumentException();
        }
        MultivariateFunction multivariateFunction = new MultivariateFunction(){

            public double value(double[] dArray) {
                return SimplexOptimizer.this.computeObjectiveValue(dArray);
            }
        };
        final boolean bl = this.getGoalType() == GoalType.MINIMIZE;
        Comparator<PointValuePair> comparator = new Comparator<PointValuePair>(){

            @Override
            public int compare(PointValuePair pointValuePair, PointValuePair pointValuePair2) {
                double d = (Double)pointValuePair.getValue();
                double d2 = (Double)pointValuePair2.getValue();
                return bl ? Double.compare(d, d2) : Double.compare(d2, d);
            }
        };
        this.simplex.build(this.getStartPoint());
        this.simplex.evaluate(multivariateFunction, comparator);
        PointValuePair[] pointValuePairArray = null;
        int n = 0;
        ConvergenceChecker<PointValuePair> convergenceChecker = this.getConvergenceChecker();
        while (true) {
            if (n > 0) {
                boolean bl2 = true;
                for (int i = 0; i < this.simplex.getSize(); ++i) {
                    PointValuePair pointValuePair = pointValuePairArray[i];
                    bl2 = bl2 && convergenceChecker.converged(n, pointValuePair, this.simplex.getPoint(i));
                }
                if (bl2) {
                    return this.simplex.getPoint(0);
                }
            }
            pointValuePairArray = this.simplex.getPoints();
            this.simplex.iterate(multivariateFunction, comparator);
            ++n;
        }
    }
}

