/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimpleValueChecker;
import org.apache.commons.math3.optimization.general.AbstractScalarDifferentiableOptimizer;
import org.apache.commons.math3.optimization.general.ConjugateGradientFormula;
import org.apache.commons.math3.optimization.general.Preconditioner;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class NonLinearConjugateGradientOptimizer
extends AbstractScalarDifferentiableOptimizer {
    private final ConjugateGradientFormula updateFormula;
    private final Preconditioner preconditioner;
    private final UnivariateSolver solver;
    private double initialStep;
    private double[] point;

    @Deprecated
    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula conjugateGradientFormula) {
        this(conjugateGradientFormula, new SimpleValueChecker());
    }

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula conjugateGradientFormula, ConvergenceChecker<PointValuePair> convergenceChecker) {
        this(conjugateGradientFormula, convergenceChecker, new BrentSolver(), new IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula conjugateGradientFormula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver) {
        this(conjugateGradientFormula, convergenceChecker, univariateSolver, new IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula conjugateGradientFormula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver, Preconditioner preconditioner) {
        super(convergenceChecker);
        this.updateFormula = conjugateGradientFormula;
        this.solver = univariateSolver;
        this.preconditioner = preconditioner;
        this.initialStep = 1.0;
    }

    public void setInitialStep(double d) {
        this.initialStep = d <= 0.0 ? 1.0 : d;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected PointValuePair doOptimize() {
        var1_1 = this.getConvergenceChecker();
        this.point = this.getStartPoint();
        var2_2 = this.getGoalType();
        var3_3 = this.point.length;
        var4_4 = this.computeObjectiveGradient(this.point);
        if (var2_2 == GoalType.MINIMIZE) {
            for (var5_5 = 0; var5_5 < var3_3; ++var5_5) {
                var4_4[var5_5] = -var4_4[var5_5];
            }
        }
        var5_6 = this.preconditioner.precondition(this.point, var4_4);
        var6_7 = (double[])var5_6.clone();
        var7_8 = 0.0;
        for (var9_9 = 0; var9_9 < var3_3; ++var9_9) {
            var7_8 += var4_4[var9_9] * var6_7[var9_9];
        }
        var9_10 = null;
        var10_11 = 0;
        var11_12 = this.getMaxEvaluations();
        block2: while (true) {
            var12_13 = this.computeObjectiveValue(this.point);
            var14_14 = var9_10;
            var9_10 = new PointValuePair(this.point, var12_13);
            if (var14_14 != null && var1_1.converged(++var10_11, var14_14, var9_10)) {
                return var9_10;
            }
            var15_15 = new LineSearchFunction(var6_7);
            var16_16 = this.findUpperBound(var15_15, 0.0, this.initialStep);
            var18_17 = this.solver.solve(var11_12, var15_15, 0.0, var16_16, 1.0E-15);
            var11_12 -= this.solver.getEvaluations();
            for (var20_19 = 0; var20_19 < this.point.length; ++var20_19) {
                v0 = var20_19;
                this.point[v0] = this.point[v0] + var18_17 * var6_7[var20_19];
            }
            var4_4 = this.computeObjectiveGradient(this.point);
            if (var2_2 == GoalType.MINIMIZE) {
                for (var20_19 = 0; var20_19 < var3_3; ++var20_19) {
                    var4_4[var20_19] = -var4_4[var20_19];
                }
            }
            var20_18 = var7_8;
            var22_20 = this.preconditioner.precondition(this.point, var4_4);
            var7_8 = 0.0;
            for (var23_22 = 0; var23_22 < var3_3; ++var23_22) {
                var7_8 += var4_4[var23_22] * var22_20[var23_22];
            }
            if (this.updateFormula == ConjugateGradientFormula.FLETCHER_REEVES) {
                var23_21 = var7_8 / var20_18;
            } else {
                var25_23 = 0.0;
                for (var27_25 = 0; var27_25 < var4_4.length; ++var27_25) {
                    var25_23 += var4_4[var27_25] * var5_6[var27_25];
                }
                var23_21 = (var7_8 - var25_23) / var20_18;
            }
            var5_6 = var22_20;
            if (var10_11 % var3_3 == 0 || var23_21 < 0.0) {
                var6_7 = (double[])var5_6.clone();
                continue;
            }
            var25_24 = 0;
            while (true) {
                if (var25_24 < var3_3) ** break;
                continue block2;
                var6_7[var25_24] = var5_6[var25_24] + var23_21 * var6_7[var25_24];
                ++var25_24;
            }
            break;
        }
    }

    private double findUpperBound(UnivariateFunction univariateFunction, double d, double d2) {
        double d3;
        double d4 = d3 = univariateFunction.value(d);
        for (double d5 = d2; d5 < Double.MAX_VALUE; d5 *= FastMath.max(2.0, d3 / d4)) {
            double d6 = d + d5;
            d4 = univariateFunction.value(d6);
            if (!(d3 * d4 <= 0.0)) continue;
            return d6;
        }
        throw new MathIllegalStateException(LocalizedFormats.UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH, new Object[0]);
    }

    private class LineSearchFunction
    implements UnivariateFunction {
        private final double[] searchDirection;

        LineSearchFunction(double[] dArray) {
            this.searchDirection = dArray;
        }

        public double value(double d) {
            double[] dArray = (double[])NonLinearConjugateGradientOptimizer.this.point.clone();
            for (int i = 0; i < dArray.length; ++i) {
                int n = i;
                dArray[n] = dArray[n] + d * this.searchDirection[i];
            }
            double[] dArray2 = NonLinearConjugateGradientOptimizer.this.computeObjectiveGradient(dArray);
            double d2 = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                d2 += dArray2[i] * this.searchDirection[i];
            }
            return d2;
        }
    }

    public static class IdentityPreconditioner
    implements Preconditioner {
        public double[] precondition(double[] dArray, double[] dArray2) {
            return (double[])dArray2.clone();
        }
    }
}

