/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.linear;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optimization.linear.Relationship;

@Deprecated
public class LinearConstraint
implements Serializable {
    private static final long serialVersionUID = -764632794033034092L;
    private final transient RealVector coefficients;
    private final Relationship relationship;
    private final double value;

    public LinearConstraint(double[] dArray, Relationship relationship, double d) {
        this(new ArrayRealVector(dArray), relationship, d);
    }

    public LinearConstraint(RealVector realVector, Relationship relationship, double d) {
        this.coefficients = realVector;
        this.relationship = relationship;
        this.value = d;
    }

    public LinearConstraint(double[] dArray, double d, Relationship relationship, double[] dArray2, double d2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        this.coefficients = new ArrayRealVector(dArray3, false);
        this.relationship = relationship;
        this.value = d2 - d;
    }

    public LinearConstraint(RealVector realVector, double d, Relationship relationship, RealVector realVector2, double d2) {
        this.coefficients = realVector.subtract(realVector2);
        this.relationship = relationship;
        this.value = d2 - d;
    }

    public RealVector getCoefficients() {
        return this.coefficients;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LinearConstraint) {
            LinearConstraint linearConstraint = (LinearConstraint)object;
            return this.relationship == linearConstraint.relationship && this.value == linearConstraint.value && this.coefficients.equals(linearConstraint.coefficients);
        }
        return false;
    }

    public int hashCode() {
        return this.relationship.hashCode() ^ Double.valueOf(this.value).hashCode() ^ this.coefficients.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        MatrixUtils.serializeRealVector(this.coefficients, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        MatrixUtils.deserializeRealVector(this, "coefficients", objectInputStream);
    }
}

