/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.univariate;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.univariate.UnivariateOptimizer;
import org.apache.commons.math3.optimization.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.Incrementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class BaseAbstractUnivariateOptimizer
implements UnivariateOptimizer {
    private final ConvergenceChecker<UnivariatePointValuePair> checker;
    private final Incrementor evaluations = new Incrementor();
    private GoalType goal;
    private double searchMin;
    private double searchMax;
    private double searchStart;
    private UnivariateFunction function;

    protected BaseAbstractUnivariateOptimizer(ConvergenceChecker<UnivariatePointValuePair> convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    public double getMin() {
        return this.searchMin;
    }

    public double getMax() {
        return this.searchMax;
    }

    public double getStartValue() {
        return this.searchStart;
    }

    protected double computeObjectiveValue(double d) {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return this.function.value(d);
    }

    @Override
    public UnivariatePointValuePair optimize(int n, UnivariateFunction univariateFunction, GoalType goalType, double d, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException();
        }
        if (goalType == null) {
            throw new NullArgumentException();
        }
        this.searchMin = d;
        this.searchMax = d2;
        this.searchStart = d3;
        this.goal = goalType;
        this.function = univariateFunction;
        this.evaluations.setMaximalCount(n);
        this.evaluations.resetCount();
        return this.doOptimize();
    }

    @Override
    public UnivariatePointValuePair optimize(int n, UnivariateFunction univariateFunction, GoalType goalType, double d, double d2) {
        return this.optimize(n, univariateFunction, goalType, d, d2, d + 0.5 * (d2 - d));
    }

    @Override
    public ConvergenceChecker<UnivariatePointValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected abstract UnivariatePointValuePair doOptimize();
}

