/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.univariate;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;

@Deprecated
public class BracketFinder {
    private static final double EPS_MIN = 1.0E-21;
    private static final double GOLD = 1.618034;
    private final double growLimit;
    private final Incrementor evaluations = new Incrementor();
    private double lo;
    private double hi;
    private double mid;
    private double fLo;
    private double fHi;
    private double fMid;

    public BracketFinder() {
        this(100.0, 50);
    }

    public BracketFinder(double d, int n) {
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException(d);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.growLimit = d;
        this.evaluations.setMaximalCount(n);
    }

    public void search(UnivariateFunction univariateFunction, GoalType goalType, double d, double d2) {
        double d3;
        double d4;
        this.evaluations.resetCount();
        boolean bl = goalType == GoalType.MINIMIZE;
        double d5 = this.eval(univariateFunction, d);
        double d6 = this.eval(univariateFunction, d2);
        if (bl ? d5 < d6 : d5 > d6) {
            d4 = d;
            d = d2;
            d2 = d4;
            d4 = d5;
            d5 = d6;
            d6 = d4;
        }
        d4 = d2 + 1.618034 * (d2 - d);
        double d7 = this.eval(univariateFunction, d4);
        while (bl ? d7 < d6 : d7 > d6) {
            double d8;
            d3 = (d2 - d) * (d6 - d7);
            double d9 = (d2 - d4) * (d6 - d5);
            double d10 = d9 - d3;
            double d11 = FastMath.abs(d10) < 1.0E-21 ? 2.0E-21 : 2.0 * d10;
            double d12 = d2 - ((d2 - d4) * d9 - (d2 - d) * d3) / d11;
            double d13 = d2 + this.growLimit * (d4 - d2);
            if ((d12 - d4) * (d2 - d12) > 0.0) {
                d8 = this.eval(univariateFunction, d12);
                if (bl ? d8 < d7 : d8 > d7) {
                    d = d2;
                    d2 = d12;
                    d5 = d6;
                    d6 = d8;
                    break;
                }
                if (bl ? d8 > d6 : d8 < d6) {
                    d4 = d12;
                    d7 = d8;
                    break;
                }
                d12 = d4 + 1.618034 * (d4 - d2);
                d8 = this.eval(univariateFunction, d12);
            } else if ((d12 - d13) * (d13 - d4) >= 0.0) {
                d12 = d13;
                d8 = this.eval(univariateFunction, d12);
            } else if ((d12 - d13) * (d4 - d12) > 0.0) {
                d8 = this.eval(univariateFunction, d12);
                if (bl ? d8 < d7 : d8 > d7) {
                    d2 = d4;
                    d4 = d12;
                    d12 = d4 + 1.618034 * (d4 - d2);
                    d6 = d7;
                    d7 = d8;
                    d8 = this.eval(univariateFunction, d12);
                }
            } else {
                d12 = d4 + 1.618034 * (d4 - d2);
                d8 = this.eval(univariateFunction, d12);
            }
            d = d2;
            d5 = d6;
            d2 = d4;
            d6 = d7;
            d4 = d12;
            d7 = d8;
        }
        this.lo = d;
        this.fLo = d5;
        this.mid = d2;
        this.fMid = d6;
        this.hi = d4;
        this.fHi = d7;
        if (this.lo > this.hi) {
            d3 = this.lo;
            this.lo = this.hi;
            this.hi = d3;
            d3 = this.fLo;
            this.fLo = this.fHi;
            this.fHi = d3;
        }
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public double getLo() {
        return this.lo;
    }

    public double getFLo() {
        return this.fLo;
    }

    public double getHi() {
        return this.hi;
    }

    public double getFHi() {
        return this.fHi;
    }

    public double getMid() {
        return this.mid;
    }

    public double getFMid() {
        return this.fMid;
    }

    private double eval(UnivariateFunction univariateFunction, double d) {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return univariateFunction.value(d);
    }
}

