/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.univariate;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.univariate.BaseAbstractUnivariateOptimizer;
import org.apache.commons.math3.optimization.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BrentOptimizer
extends BaseAbstractUnivariateOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public BrentOptimizer(double d, double d2, ConvergenceChecker<UnivariatePointValuePair> convergenceChecker) {
        super(convergenceChecker);
        if (d < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(d, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        this.relativeThreshold = d;
        this.absoluteThreshold = d2;
    }

    public BrentOptimizer(double d, double d2) {
        this(d, d2, null);
    }

    @Override
    protected UnivariatePointValuePair doOptimize() {
        UnivariatePointValuePair univariatePointValuePair;
        double d;
        double d2;
        double d3;
        boolean bl = this.getGoalType() == GoalType.MINIMIZE;
        double d4 = this.getMin();
        double d5 = this.getStartValue();
        double d6 = this.getMax();
        ConvergenceChecker<UnivariatePointValuePair> convergenceChecker = this.getConvergenceChecker();
        if (d4 < d6) {
            d3 = d4;
            d2 = d6;
        } else {
            d3 = d6;
            d2 = d4;
        }
        double d7 = d = d5;
        double d8 = d;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = this.computeObjectiveValue(d);
        if (!bl) {
            d11 = -d11;
        }
        double d12 = d11;
        double d13 = d11;
        UnivariatePointValuePair univariatePointValuePair2 = null;
        UnivariatePointValuePair univariatePointValuePair3 = univariatePointValuePair = new UnivariatePointValuePair(d, bl ? d11 : -d11);
        int n = 0;
        while (true) {
            boolean bl2;
            double d14 = 0.5 * (d3 + d2);
            double d15 = this.relativeThreshold * FastMath.abs(d) + this.absoluteThreshold;
            double d16 = 2.0 * d15;
            boolean bl3 = bl2 = FastMath.abs(d - d14) <= d16 - 0.5 * (d2 - d3);
            if (!bl2) {
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                if (FastMath.abs(d10) > d15) {
                    d19 = (d - d8) * (d11 - d12);
                    d18 = (d - d7) * (d11 - d13);
                    d17 = (d - d7) * d18 - (d - d8) * d19;
                    if ((d18 = 2.0 * (d18 - d19)) > 0.0) {
                        d17 = -d17;
                    } else {
                        d18 = -d18;
                    }
                    d19 = d10;
                    d10 = d9;
                    if (d17 > d18 * (d3 - d) && d17 < d18 * (d2 - d) && FastMath.abs(d17) < FastMath.abs(0.5 * d18 * d19)) {
                        d9 = d17 / d18;
                        d20 = d + d9;
                        if (d20 - d3 < d16 || d2 - d20 < d16) {
                            d9 = d <= d14 ? d15 : -d15;
                        }
                    } else {
                        d10 = d < d14 ? d2 - d : d3 - d;
                        d9 = GOLDEN_SECTION * d10;
                    }
                } else {
                    d10 = d < d14 ? d2 - d : d3 - d;
                    d9 = GOLDEN_SECTION * d10;
                }
                d20 = FastMath.abs(d9) < d15 ? (d9 >= 0.0 ? d + d15 : d - d15) : d + d9;
                double d21 = this.computeObjectiveValue(d20);
                if (!bl) {
                    d21 = -d21;
                }
                univariatePointValuePair2 = univariatePointValuePair;
                univariatePointValuePair = new UnivariatePointValuePair(d20, bl ? d21 : -d21);
                univariatePointValuePair3 = this.best(univariatePointValuePair3, this.best(univariatePointValuePair2, univariatePointValuePair, bl), bl);
                if (convergenceChecker != null && convergenceChecker.converged(n, univariatePointValuePair2, univariatePointValuePair)) {
                    return univariatePointValuePair3;
                }
                if (d21 <= d11) {
                    if (d20 < d) {
                        d2 = d;
                    } else {
                        d3 = d;
                    }
                    d7 = d8;
                    d12 = d13;
                    d8 = d;
                    d13 = d11;
                    d = d20;
                    d11 = d21;
                } else {
                    if (d20 < d) {
                        d3 = d20;
                    } else {
                        d2 = d20;
                    }
                    if (d21 <= d13 || Precision.equals(d8, d)) {
                        d7 = d8;
                        d12 = d13;
                        d8 = d20;
                        d13 = d21;
                    } else if (d21 <= d12 || Precision.equals(d7, d) || Precision.equals(d7, d8)) {
                        d7 = d20;
                        d12 = d21;
                    }
                }
            } else {
                return this.best(univariatePointValuePair3, this.best(univariatePointValuePair2, univariatePointValuePair, bl), bl);
            }
            ++n;
        }
    }

    private UnivariatePointValuePair best(UnivariatePointValuePair univariatePointValuePair, UnivariatePointValuePair univariatePointValuePair2, boolean bl) {
        if (univariatePointValuePair == null) {
            return univariatePointValuePair2;
        }
        if (univariatePointValuePair2 == null) {
            return univariatePointValuePair;
        }
        if (bl) {
            return univariatePointValuePair.getValue() <= univariatePointValuePair2.getValue() ? univariatePointValuePair : univariatePointValuePair2;
        }
        return univariatePointValuePair.getValue() >= univariatePointValuePair2.getValue() ? univariatePointValuePair : univariatePointValuePair2;
    }
}

