/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractRandomGenerator
implements RandomGenerator {
    private double cachedNormalDeviate = Double.NaN;

    public void clear() {
        this.cachedNormalDeviate = Double.NaN;
    }

    public void setSeed(int n) {
        this.setSeed((long)n);
    }

    public void setSeed(int[] nArray) {
        long l = 0xFFFFFFFBL;
        long l2 = 0L;
        for (int n : nArray) {
            l2 = l2 * 0xFFFFFFFBL + (long)n;
        }
        this.setSeed(l2);
    }

    public abstract void setSeed(long var1);

    public void nextBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = this.nextInt();
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    n2 >>= 8;
                }
                byArray[n++] = (byte)n2;
                if (n != byArray.length) continue;
                return;
            }
        }
    }

    public int nextInt() {
        return (int)((2.0 * this.nextDouble() - 1.0) * 2.147483647E9);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        int n2 = (int)(this.nextDouble() * (double)n);
        return n2 < n ? n2 : n - 1;
    }

    public long nextLong() {
        return (long)((2.0 * this.nextDouble() - 1.0) * 9.223372036854776E18);
    }

    public boolean nextBoolean() {
        return this.nextDouble() <= 0.5;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public abstract double nextDouble();

    public double nextGaussian() {
        if (!Double.isNaN(this.cachedNormalDeviate)) {
            double d = this.cachedNormalDeviate;
            this.cachedNormalDeviate = Double.NaN;
            return d;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        while (d3 >= 1.0) {
            d = 2.0 * this.nextDouble() - 1.0;
            d2 = 2.0 * this.nextDouble() - 1.0;
            d3 = d * d + d2 * d2;
        }
        if (d3 != 0.0) {
            d3 = FastMath.sqrt(-2.0 * FastMath.log(d3) / d3);
        }
        this.cachedNormalDeviate = d2 * d3;
        return d * d3;
    }
}

