/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomVectorGenerator;
import org.apache.commons.math3.util.MathUtils;

public class HaltonSequenceGenerator
implements RandomVectorGenerator {
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173};
    private static final int[] WEIGHTS = new int[]{1, 2, 3, 3, 8, 11, 12, 14, 7, 18, 12, 13, 17, 18, 29, 14, 18, 43, 41, 44, 40, 30, 47, 65, 71, 28, 40, 60, 79, 89, 56, 50, 52, 61, 108, 56, 66, 63, 60, 66};
    private final int dimension;
    private int count = 0;
    private final int[] base;
    private final int[] weight;

    public HaltonSequenceGenerator(int n) {
        this(n, PRIMES, WEIGHTS);
    }

    public HaltonSequenceGenerator(int n, int[] nArray, int[] nArray2) {
        MathUtils.checkNotNull(nArray);
        if (n < 1 || n > nArray.length) {
            throw new OutOfRangeException(n, (Number)1, PRIMES.length);
        }
        if (nArray2 != null && nArray2.length != nArray.length) {
            throw new DimensionMismatchException(nArray2.length, nArray.length);
        }
        this.dimension = n;
        this.base = (int[])nArray.clone();
        this.weight = nArray2 == null ? null : (int[])nArray2.clone();
        this.count = 0;
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            int n = this.count;
            double d = 1.0 / (double)this.base[i];
            int n2 = 0;
            while (n > 0) {
                int n3 = this.scramble(i, n2, this.base[i], n % this.base[i]);
                int n4 = i;
                dArray[n4] = dArray[n4] + d * (double)n3;
                n /= this.base[i];
                d /= (double)this.base[i];
            }
        }
        ++this.count;
        return dArray;
    }

    protected int scramble(int n, int n2, int n3, int n4) {
        return this.weight != null ? this.weight[n] * n4 % n3 : n4;
    }

    public double[] skipTo(int n) {
        this.count = n;
        return this.nextVector();
    }

    public int getNextIndex() {
        return this.count;
    }
}

