/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomVectorGenerator;
import org.apache.commons.math3.util.FastMath;

public class UnitSphereRandomVectorGenerator
implements RandomVectorGenerator {
    private final RandomGenerator rand;
    private final int dimension;

    public UnitSphereRandomVectorGenerator(int n, RandomGenerator randomGenerator) {
        this.dimension = n;
        this.rand = randomGenerator;
    }

    public UnitSphereRandomVectorGenerator(int n) {
        this(n, new MersenneTwister());
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        double d = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            double d2;
            dArray[i] = d2 = this.rand.nextGaussian();
            d += d2 * d2;
        }
        double d3 = 1.0 / FastMath.sqrt(d);
        int n = 0;
        while (n < this.dimension) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d3;
        }
        return dArray;
    }
}

