/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private final SortedMap<Comparable<?>, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator<?> comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable<?> comparable : this.freqTable.keySet()) {
            stringBuilder.append(comparable);
            stringBuilder.append('\t');
            stringBuilder.append(this.getCount(comparable));
            stringBuilder.append('\t');
            stringBuilder.append(numberFormat.format(this.getPct(comparable)));
            stringBuilder.append('\t');
            stringBuilder.append(numberFormat.format(this.getCumPct(comparable)));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void addValue(Comparable<?> comparable) {
        this.incrementValue(comparable, 1L);
    }

    public void addValue(int n) {
        this.addValue(Long.valueOf(n));
    }

    public void addValue(long l) {
        this.addValue(Long.valueOf(l));
    }

    public void addValue(char c) {
        this.addValue(Character.valueOf(c));
    }

    public void incrementValue(Comparable<?> l, long l2) {
        Long l3 = l;
        if (l instanceof Integer) {
            l3 = ((Integer)((Object)l)).longValue();
        }
        try {
            Long l4 = (Long)this.freqTable.get(l3);
            if (l4 == null) {
                this.freqTable.put(l3, l2);
            } else {
                this.freqTable.put(l3, l4 + l2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSTANCES_NOT_COMPARABLE_TO_EXISTING_VALUES, l.getClass().getName());
        }
    }

    public void incrementValue(int n, long l) {
        this.incrementValue(Long.valueOf(n), l);
    }

    public void incrementValue(long l, long l2) {
        this.incrementValue(Long.valueOf(l), l2);
    }

    public void incrementValue(char c, long l) {
        this.incrementValue(Character.valueOf(c), l);
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<Comparable<?>> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public Iterator<Map.Entry<Comparable<?>, Long>> entrySetIterator() {
        return this.freqTable.entrySet().iterator();
    }

    public long getSumFreq() {
        long l = 0L;
        Iterator<Long> iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            l += iterator.next().longValue();
        }
        return l;
    }

    public long getCount(Comparable<?> comparable) {
        if (comparable instanceof Integer) {
            return this.getCount(((Integer)comparable).longValue());
        }
        long l = 0L;
        try {
            Long l2 = (Long)this.freqTable.get(comparable);
            if (l2 != null) {
                l = l2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return l;
    }

    public long getCount(int n) {
        return this.getCount(Long.valueOf(n));
    }

    public long getCount(long l) {
        return this.getCount(Long.valueOf(l));
    }

    public long getCount(char c) {
        return this.getCount(Character.valueOf(c));
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    public double getPct(Comparable<?> comparable) {
        long l = this.getSumFreq();
        if (l == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(comparable) / (double)l;
    }

    public double getPct(int n) {
        return this.getPct(Long.valueOf(n));
    }

    public double getPct(long l) {
        return this.getPct(Long.valueOf(l));
    }

    public double getPct(char c) {
        return this.getPct(Character.valueOf(c));
    }

    public long getCumFreq(Comparable<?> comparable) {
        Object object;
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (comparable instanceof Integer) {
            return this.getCumFreq(((Integer)comparable).longValue());
        }
        Comparator<Comparable<?>> comparator = this.freqTable.comparator();
        if (comparator == null) {
            comparator = new NaturalComparator();
        }
        long l = 0L;
        try {
            object = (Long)this.freqTable.get(comparable);
            if (object != null) {
                l = (Long)object;
            }
        }
        catch (ClassCastException classCastException) {
            return l;
        }
        if (comparator.compare(comparable, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (comparator.compare(comparable, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        object = this.valuesIterator();
        while (object.hasNext()) {
            Comparable comparable2 = (Comparable)object.next();
            if (comparator.compare(comparable, comparable2) > 0) {
                l += this.getCount(comparable2);
                continue;
            }
            return l;
        }
        return l;
    }

    public long getCumFreq(int n) {
        return this.getCumFreq(Long.valueOf(n));
    }

    public long getCumFreq(long l) {
        return this.getCumFreq(Long.valueOf(l));
    }

    public long getCumFreq(char c) {
        return this.getCumFreq(Character.valueOf(c));
    }

    public double getCumPct(Comparable<?> comparable) {
        long l = this.getSumFreq();
        if (l == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(comparable) / (double)l;
    }

    public double getCumPct(int n) {
        return this.getCumPct(Long.valueOf(n));
    }

    public double getCumPct(long l) {
        return this.getCumPct(Long.valueOf(l));
    }

    public double getCumPct(char c) {
        return this.getCumPct(Character.valueOf(c));
    }

    public List<Comparable<?>> getMode() {
        long l = 0L;
        for (Long object : this.freqTable.values()) {
            long entry = object;
            if (entry <= l) continue;
            l = entry;
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Comparable<?>, Long> entry : this.freqTable.entrySet()) {
            long l2 = entry.getValue();
            if (l2 != l) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public void merge(Frequency frequency) {
        MathUtils.checkNotNull(frequency, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        Iterator<Map.Entry<Comparable<?>, Long>> iterator = frequency.entrySetIterator();
        while (iterator.hasNext()) {
            Map.Entry<Comparable<?>, Long> entry = iterator.next();
            this.incrementValue(entry.getKey(), (long)entry.getValue());
        }
    }

    public void merge(Collection<Frequency> collection) {
        MathUtils.checkNotNull(collection, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        for (Frequency frequency : collection) {
            this.merge(frequency);
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Frequency)) {
            return false;
        }
        Frequency frequency = (Frequency)object;
        return !(this.freqTable == null ? frequency.freqTable != null : !this.freqTable.equals(frequency.freqTable));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalComparator<T extends Comparable<T>>
    implements Comparator<Comparable<T>>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(Comparable<T> comparable, Comparable<T> comparable2) {
            return comparable.compareTo(comparable2);
        }
    }
}

