/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.clustering.Cluster;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class KMeansPlusPlusClusterer<T extends Clusterable<T>> {
    private final Random random;
    private final EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(Random random) {
        this(random, EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(Random random, EmptyClusterStrategy emptyClusterStrategy) {
        this.random = random;
        this.emptyStrategy = emptyClusterStrategy;
    }

    public List<Cluster<T>> cluster(Collection<T> collection, int n, int n2, int n3) {
        List<Cluster<T>> list = null;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n2; ++i) {
            List<Cluster<T>> list2 = this.cluster(collection, n, n3);
            double d2 = 0.0;
            for (Cluster<T> cluster : list2) {
                if (cluster.getPoints().isEmpty()) continue;
                T t = cluster.getCenter();
                Variance variance = new Variance();
                for (Clusterable clusterable : cluster.getPoints()) {
                    variance.increment(clusterable.distanceFrom(t));
                }
                d2 += variance.getResult();
            }
            if (!(d2 <= d)) continue;
            list = list2;
            d = d2;
        }
        return list;
    }

    public List<Cluster<T>> cluster(Collection<T> collection, int n, int n2) {
        MathUtils.checkNotNull(collection);
        if (collection.size() < n) {
            throw new NumberIsTooSmallException(collection.size(), (Number)n, false);
        }
        List<Cluster<T>> list = KMeansPlusPlusClusterer.chooseInitialCenters(collection, n, this.random);
        int[] nArray = new int[collection.size()];
        KMeansPlusPlusClusterer.assignPointsToClusters(list, collection, nArray);
        int n3 = n2 < 0 ? Integer.MAX_VALUE : n2;
        for (int i = 0; i < n3; ++i) {
            boolean bl = false;
            ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
            for (Cluster<T> cluster : list) {
                Clusterable clusterable;
                if (cluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            clusterable = this.getPointFromLargestVarianceCluster(list);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            clusterable = this.getPointFromLargestNumberCluster(list);
                            break;
                        }
                        case FARTHEST_POINT: {
                            clusterable = this.getFarthestPoint(list);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
                        }
                    }
                    bl = true;
                } else {
                    clusterable = (Clusterable)cluster.getCenter().centroidOf(cluster.getPoints());
                }
                arrayList.add(new Cluster<Clusterable>(clusterable));
            }
            int n4 = KMeansPlusPlusClusterer.assignPointsToClusters(arrayList, collection, nArray);
            list = arrayList;
            if (n4 != 0 || bl) continue;
            return list;
        }
        return list;
    }

    private static <T extends Clusterable<T>> int assignPointsToClusters(List<Cluster<T>> list, Collection<T> collection, int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (Clusterable clusterable : collection) {
            int n3 = KMeansPlusPlusClusterer.getNearestCluster(list, clusterable);
            if (n3 != nArray[n2]) {
                ++n;
            }
            Cluster<Clusterable> cluster = list.get(n3);
            cluster.addPoint(clusterable);
            nArray[n2++] = n3;
        }
        return n;
    }

    private static <T extends Clusterable<T>> List<Cluster<T>> chooseInitialCenters(Collection<T> collection, int n, Random random) {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(collection));
        int n2 = list.size();
        boolean[] blArray = new boolean[n2];
        ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
        int n3 = random.nextInt(n2);
        Clusterable clusterable = (Clusterable)list.get(n3);
        arrayList.add(new Cluster<Clusterable>(clusterable));
        blArray[n3] = true;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            if (i == n3) continue;
            double d = clusterable.distanceFrom(list.get(i));
            dArray[i] = d * d;
        }
        while (arrayList.size() < n) {
            int n4;
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                if (blArray[i]) continue;
                d += dArray[i];
            }
            double d2 = random.nextDouble() * d;
            int n5 = -1;
            double d3 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (blArray[n4] || !((d3 += dArray[n4]) >= d2)) continue;
                n5 = n4;
                break;
            }
            if (n5 == -1) {
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    if (blArray[n4]) continue;
                    n5 = n4;
                    break;
                }
            }
            if (n5 < 0) break;
            Clusterable clusterable2 = (Clusterable)list.get(n5);
            arrayList.add(new Cluster<Clusterable>(clusterable2));
            blArray[n5] = true;
            if (arrayList.size() >= n) continue;
            for (int i = 0; i < n2; ++i) {
                double d4;
                double d5;
                if (blArray[i] || !((d5 = (d4 = clusterable2.distanceFrom(list.get(i))) * d4) < dArray[i])) continue;
                dArray[i] = d5;
            }
        }
        return arrayList;
    }

    private T getPointFromLargestVarianceCluster(Collection<Cluster<T>> collection) {
        double d = Double.NEGATIVE_INFINITY;
        Cluster<T> cluster = null;
        for (Cluster<T> cluster2 : collection) {
            if (cluster2.getPoints().isEmpty()) continue;
            T t = cluster2.getCenter();
            Variance variance = new Variance();
            for (Clusterable clusterable : cluster2.getPoints()) {
                variance.increment(clusterable.distanceFrom(t));
            }
            double d2 = variance.getResult();
            if (!(d2 > d)) continue;
            d = d2;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<Cluster<T>> collection) {
        int n = 0;
        Cluster<T> cluster = null;
        for (Cluster<T> cluster2 : collection) {
            int n2 = cluster2.getPoints().size();
            if (n2 <= n) continue;
            n = n2;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getFarthestPoint(Collection<Cluster<T>> collection) {
        double d = Double.NEGATIVE_INFINITY;
        Cluster<T> cluster = null;
        int n = -1;
        for (Cluster<T> cluster2 : collection) {
            T t = cluster2.getCenter();
            List<T> list = cluster2.getPoints();
            for (int i = 0; i < list.size(); ++i) {
                double d2 = ((Clusterable)list.get(i)).distanceFrom(t);
                if (!(d2 > d)) continue;
                d = d2;
                cluster = cluster2;
                n = i;
            }
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        return (T)((Clusterable)cluster.getPoints().remove(n));
    }

    private static <T extends Clusterable<T>> int getNearestCluster(Collection<Cluster<T>> collection, T object) {
        double d = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        for (Cluster<T> cluster : collection) {
            double d2 = object.distanceFrom(cluster.getCenter());
            if (d2 < d) {
                d = d2;
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmptyClusterStrategy {
        LARGEST_VARIANCE,
        LARGEST_POINTS_NUMBER,
        FARTHEST_POINT,
        ERROR;

    }
}

