/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

public class KendallsCorrelation {
    private final RealMatrix correlationMatrix;

    public KendallsCorrelation() {
        this.correlationMatrix = null;
    }

    public KendallsCorrelation(double[][] dArray) {
        this(MatrixUtils.createRealMatrix(dArray));
    }

    public KendallsCorrelation(RealMatrix realMatrix) {
        this.correlationMatrix = this.computeCorrelationMatrix(realMatrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        int n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = this.correlation(realMatrix.getColumn(i), realMatrix.getColumn(j));
                blockRealMatrix.setEntry(i, j, d);
                blockRealMatrix.setEntry(j, i, d);
            }
            blockRealMatrix.setEntry(i, i, 1.0);
        }
        return blockRealMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] dArray, double[] dArray2) {
        int n;
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        int n2 = dArray.length;
        long l = KendallsCorrelation.sum(n2 - 1);
        Pair[] pairArray = new Pair[n2];
        for (int i = 0; i < n2; ++i) {
            pairArray[i] = new Pair<Double, Double>(dArray[i], dArray2[i]);
        }
        Arrays.sort(pairArray, new Comparator<Pair<Double, Double>>(){

            @Override
            public int compare(Pair<Double, Double> pair, Pair<Double, Double> pair2) {
                int n = pair.getFirst().compareTo(pair2.getFirst());
                return n != 0 ? n : pair.getSecond().compareTo(pair2.getSecond());
            }
        });
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        long l5 = 1L;
        Pair pair = pairArray[0];
        for (int i = 1; i < n2; ++i) {
            Pair pair2 = pairArray[i];
            if (((Double)pair2.getFirst()).equals(pair.getFirst())) {
                ++l4;
                if (((Double)pair2.getSecond()).equals(pair.getSecond())) {
                    ++l5;
                } else {
                    l3 += KendallsCorrelation.sum(l5 - 1L);
                    l5 = 1L;
                }
            } else {
                l2 += KendallsCorrelation.sum(l4 - 1L);
                l4 = 1L;
                l3 += KendallsCorrelation.sum(l5 - 1L);
                l5 = 1L;
            }
            pair = pair2;
        }
        l2 += KendallsCorrelation.sum(l4 - 1L);
        l3 += KendallsCorrelation.sum(l5 - 1L);
        long l6 = 0L;
        Pair[] pairArray2 = new Pair[n2];
        for (int i = 1; i < n2; i <<= 1) {
            for (int j = 0; j < n2; j += 2 * i) {
                int n3;
                int n4 = j;
                n = n3 = FastMath.min(n4 + i, n2);
                int n5 = FastMath.min(n + i, n2);
                int n6 = j;
                while (n4 < n3 || n < n5) {
                    if (n4 < n3) {
                        if (n < n5) {
                            if (((Double)pairArray[n4].getSecond()).compareTo((Double)pairArray[n].getSecond()) <= 0) {
                                pairArray2[n6] = pairArray[n4];
                                ++n4;
                            } else {
                                pairArray2[n6] = pairArray[n];
                                ++n;
                                l6 += (long)(n3 - n4);
                            }
                        } else {
                            pairArray2[n6] = pairArray[n4];
                            ++n4;
                        }
                    } else {
                        pairArray2[n6] = pairArray[n];
                        ++n;
                    }
                    ++n6;
                }
            }
            Pair[] pairArray3 = pairArray;
            pairArray = pairArray2;
            pairArray2 = pairArray3;
        }
        long l7 = 0L;
        long l8 = 1L;
        pair = pairArray[0];
        for (n = 1; n < n2; ++n) {
            Pair pair3 = pairArray[n];
            if (((Double)pair3.getSecond()).equals(pair.getSecond())) {
                ++l8;
            } else {
                l7 += KendallsCorrelation.sum(l8 - 1L);
                l8 = 1L;
            }
            pair = pair3;
        }
        long l9 = l - l2 - (l7 += KendallsCorrelation.sum(l8 - 1L)) + l3 - 2L * l6;
        double d = (double)(l - l2) * (double)(l - l7);
        return (double)l9 / FastMath.sqrt(d);
    }

    private static long sum(long l) {
        return l * (l + 1L) / 2L;
    }
}

