/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.commons.math3.util.FastMath;

public class PearsonsCorrelation {
    private final RealMatrix correlationMatrix;
    private final int nObs;

    public PearsonsCorrelation() {
        this.correlationMatrix = null;
        this.nObs = 0;
    }

    public PearsonsCorrelation(double[][] dArray) {
        this(new BlockRealMatrix(dArray));
    }

    public PearsonsCorrelation(RealMatrix realMatrix) {
        this.nObs = realMatrix.getRowDimension();
        this.correlationMatrix = this.computeCorrelationMatrix(realMatrix);
    }

    public PearsonsCorrelation(Covariance covariance) {
        RealMatrix realMatrix = covariance.getCovarianceMatrix();
        if (realMatrix == null) {
            throw new NullArgumentException(LocalizedFormats.COVARIANCE_MATRIX, new Object[0]);
        }
        this.nObs = covariance.getN();
        this.correlationMatrix = this.covarianceToCorrelation(realMatrix);
    }

    public PearsonsCorrelation(RealMatrix realMatrix, int n) {
        this.nObs = n;
        this.correlationMatrix = this.covarianceToCorrelation(realMatrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix getCorrelationStandardErrors() {
        int n = this.correlationMatrix.getColumnDimension();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = this.correlationMatrix.getEntry(i, j);
                dArray[i][j] = FastMath.sqrt((1.0 - d * d) / (double)(this.nObs - 2));
            }
        }
        return new BlockRealMatrix(dArray);
    }

    public RealMatrix getCorrelationPValues() {
        TDistribution tDistribution = new TDistribution(this.nObs - 2);
        int n = this.correlationMatrix.getColumnDimension();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) {
                    dArray[i][j] = 0.0;
                    continue;
                }
                double d = this.correlationMatrix.getEntry(i, j);
                double d2 = FastMath.abs(d * FastMath.sqrt((double)(this.nObs - 2) / (1.0 - d * d)));
                dArray[i][j] = 2.0 * tDistribution.cumulativeProbability(-d2);
            }
        }
        return new BlockRealMatrix(dArray);
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        this.checkSufficientData(realMatrix);
        int n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = this.correlation(realMatrix.getColumn(i), realMatrix.getColumn(j));
                blockRealMatrix.setEntry(i, j, d);
                blockRealMatrix.setEntry(j, i, d);
            }
            blockRealMatrix.setEntry(i, i, 1.0);
        }
        return blockRealMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] dArray, double[] dArray2) {
        SimpleRegression simpleRegression = new SimpleRegression();
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, dArray.length, 2);
        }
        for (int i = 0; i < dArray.length; ++i) {
            simpleRegression.addData(dArray[i], dArray2[i]);
        }
        return simpleRegression.getR();
    }

    public RealMatrix covarianceToCorrelation(RealMatrix realMatrix) {
        int n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            double d = FastMath.sqrt(realMatrix.getEntry(i, i));
            blockRealMatrix.setEntry(i, i, 1.0);
            for (int j = 0; j < i; ++j) {
                double d2 = realMatrix.getEntry(i, j) / (d * FastMath.sqrt(realMatrix.getEntry(j, j)));
                blockRealMatrix.setEntry(i, j, d2);
                blockRealMatrix.setEntry(j, i, d2);
            }
        }
        return blockRealMatrix;
    }

    private void checkSufficientData(RealMatrix realMatrix) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        if (n < 2 || n2 < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, n, n2);
        }
    }
}

