/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.RankingAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpearmansCorrelation {
    private final RealMatrix data;
    private final RankingAlgorithm rankingAlgorithm;
    private final PearsonsCorrelation rankCorrelation;

    public SpearmansCorrelation() {
        this(new NaturalRanking());
    }

    public SpearmansCorrelation(RankingAlgorithm rankingAlgorithm) {
        this.data = null;
        this.rankingAlgorithm = rankingAlgorithm;
        this.rankCorrelation = null;
    }

    public SpearmansCorrelation(RealMatrix realMatrix) {
        this(realMatrix, new NaturalRanking());
    }

    public SpearmansCorrelation(RealMatrix realMatrix, RankingAlgorithm rankingAlgorithm) {
        this.rankingAlgorithm = rankingAlgorithm;
        this.data = this.rankTransform(realMatrix);
        this.rankCorrelation = new PearsonsCorrelation(this.data);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.rankCorrelation.getCorrelationMatrix();
    }

    public PearsonsCorrelation getRankCorrelation() {
        return this.rankCorrelation;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = this.rankTransform(realMatrix);
        return new PearsonsCorrelation().computeCorrelationMatrix(realMatrix2);
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, dArray.length, 2);
        }
        double[] dArray3 = dArray;
        double[] dArray4 = dArray2;
        if (this.rankingAlgorithm instanceof NaturalRanking && NaNStrategy.REMOVED == ((NaturalRanking)this.rankingAlgorithm).getNanStrategy()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.addAll(this.getNaNPositions(dArray));
            hashSet.addAll(this.getNaNPositions(dArray2));
            dArray3 = this.removeValues(dArray, hashSet);
            dArray4 = this.removeValues(dArray2, hashSet);
        }
        return new PearsonsCorrelation().correlation(this.rankingAlgorithm.rank(dArray3), this.rankingAlgorithm.rank(dArray4));
    }

    private RealMatrix rankTransform(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = null;
        if (this.rankingAlgorithm instanceof NaturalRanking && ((NaturalRanking)this.rankingAlgorithm).getNanStrategy() == NaNStrategy.REMOVED) {
            int n;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n = 0; n < realMatrix.getColumnDimension(); ++n) {
                hashSet.addAll(this.getNaNPositions(realMatrix.getColumn(n)));
            }
            if (!hashSet.isEmpty()) {
                realMatrix2 = new BlockRealMatrix(realMatrix.getRowDimension() - hashSet.size(), realMatrix.getColumnDimension());
                for (n = 0; n < realMatrix2.getColumnDimension(); ++n) {
                    realMatrix2.setColumn(n, this.removeValues(realMatrix.getColumn(n), hashSet));
                }
            }
        }
        if (realMatrix2 == null) {
            realMatrix2 = realMatrix.copy();
        }
        for (int i = 0; i < realMatrix2.getColumnDimension(); ++i) {
            realMatrix2.setColumn(i, this.rankingAlgorithm.rank(realMatrix2.getColumn(i)));
        }
        return realMatrix2;
    }

    private List<Integer> getNaNPositions(double[] dArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private double[] removeValues(double[] dArray, Set<Integer> set) {
        if (set.isEmpty()) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length - set.size()];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (set.contains(i)) continue;
            dArray2[n++] = dArray[i];
        }
        return dArray2;
    }
}

