/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.util.MathArrays;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    public void setData(double[] dArray) {
        this.storedData = dArray == null ? null : (double[])dArray.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        if (n + n2 > dArray.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n + n2), dArray.length, true);
        }
        this.storedData = new double[n2];
        System.arraycopy(dArray, n, this.storedData, 0, n2);
    }

    public double evaluate() {
        return this.evaluate(this.storedData);
    }

    public double evaluate(double[] dArray) {
        this.test(dArray, 0, 0);
        return this.evaluate(dArray, 0, dArray.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] dArray, int n, int n2) {
        return MathArrays.verifyValues(dArray, n, n2, false);
    }

    protected boolean test(double[] dArray, int n, int n2, boolean bl) {
        return MathArrays.verifyValues(dArray, n, n2, bl);
    }

    protected boolean test(double[] dArray, double[] dArray2, int n, int n2) {
        return MathArrays.verifyValues(dArray, dArray2, n, n2, false);
    }

    protected boolean test(double[] dArray, double[] dArray2, int n, int n2, boolean bl) {
        return MathArrays.verifyValues(dArray, dArray2, n, n2, bl);
    }
}

