/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.util.MathUtils;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = -1296043746617791564L;
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment firstMoment) {
        this.moment = firstMoment;
        this.incMoment = false;
    }

    public Mean(Mean mean) {
        Mean.copy(mean, this);
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double getResult() {
        return this.moment.m1;
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] dArray, int n, int n2) {
        if (this.test(dArray, n, n2)) {
            Sum sum = new Sum();
            double d = n2;
            double d2 = sum.evaluate(dArray, n, n2) / d;
            double d3 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d3 += dArray[i] - d2;
            }
            return d2 + d3 / d;
        }
        return Double.NaN;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        if (this.test(dArray, dArray2, n, n2)) {
            Sum sum = new Sum();
            double d = sum.evaluate(dArray2, n, n2);
            double d2 = sum.evaluate(dArray, dArray2, n, n2) / d;
            double d3 = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d3 += dArray2[i] * (dArray[i] - d2);
            }
            return d2 + d3 / d;
        }
        return Double.NaN;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public Mean copy() {
        Mean mean = new Mean();
        Mean.copy(this, mean);
        return mean;
    }

    public static void copy(Mean mean, Mean mean2) {
        MathUtils.checkNotNull(mean);
        MathUtils.checkNotNull(mean2);
        mean2.setData(mean.getDataRef());
        mean2.incMoment = mean.incMoment;
        mean2.moment = mean.moment.copy();
    }
}

