/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class StandardDeviation
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 5728716329662425188L;
    private Variance variance = null;

    public StandardDeviation() {
        this.variance = new Variance();
    }

    public StandardDeviation(SecondMoment secondMoment) {
        this.variance = new Variance(secondMoment);
    }

    public StandardDeviation(StandardDeviation standardDeviation) {
        StandardDeviation.copy(standardDeviation, this);
    }

    public StandardDeviation(boolean bl) {
        this.variance = new Variance(bl);
    }

    public StandardDeviation(boolean bl, SecondMoment secondMoment) {
        this.variance = new Variance(bl, secondMoment);
    }

    public void increment(double d) {
        this.variance.increment(d);
    }

    public long getN() {
        return this.variance.getN();
    }

    public double getResult() {
        return FastMath.sqrt(this.variance.getResult());
    }

    public void clear() {
        this.variance.clear();
    }

    public double evaluate(double[] dArray) {
        return FastMath.sqrt(this.variance.evaluate(dArray));
    }

    public double evaluate(double[] dArray, int n, int n2) {
        return FastMath.sqrt(this.variance.evaluate(dArray, n, n2));
    }

    public double evaluate(double[] dArray, double d, int n, int n2) {
        return FastMath.sqrt(this.variance.evaluate(dArray, d, n, n2));
    }

    public double evaluate(double[] dArray, double d) {
        return FastMath.sqrt(this.variance.evaluate(dArray, d));
    }

    public boolean isBiasCorrected() {
        return this.variance.isBiasCorrected();
    }

    public void setBiasCorrected(boolean bl) {
        this.variance.setBiasCorrected(bl);
    }

    public StandardDeviation copy() {
        StandardDeviation standardDeviation = new StandardDeviation();
        StandardDeviation.copy(this, standardDeviation);
        return standardDeviation;
    }

    public static void copy(StandardDeviation standardDeviation, StandardDeviation standardDeviation2) {
        MathUtils.checkNotNull(standardDeviation);
        MathUtils.checkNotNull(standardDeviation2);
        standardDeviation2.setData(standardDeviation.getDataRef());
        standardDeviation2.variance = standardDeviation.variance.copy();
    }
}

