/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.util.MathUtils;

class ThirdMoment
extends SecondMoment
implements Serializable {
    private static final long serialVersionUID = -7818711964045118679L;
    protected double m3;
    protected double nDevSq;

    ThirdMoment() {
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    ThirdMoment(ThirdMoment thirdMoment) {
        ThirdMoment.copy(thirdMoment, this);
    }

    public void increment(double d) {
        if (this.n < 1L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
            this.m3 = 0.0;
        }
        double d2 = this.m2;
        super.increment(d);
        this.nDevSq = this.nDev * this.nDev;
        double d3 = this.n;
        this.m3 = this.m3 - 3.0 * this.nDev * d2 + (d3 - 1.0) * (d3 - 2.0) * this.nDevSq * this.dev;
    }

    public double getResult() {
        return this.m3;
    }

    public void clear() {
        super.clear();
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }

    public ThirdMoment copy() {
        ThirdMoment thirdMoment = new ThirdMoment();
        ThirdMoment.copy(this, thirdMoment);
        return thirdMoment;
    }

    public static void copy(ThirdMoment thirdMoment, ThirdMoment thirdMoment2) {
        MathUtils.checkNotNull(thirdMoment);
        MathUtils.checkNotNull(thirdMoment2);
        SecondMoment.copy(thirdMoment, thirdMoment2);
        thirdMoment2.m3 = thirdMoment.m3;
        thirdMoment2.nDevSq = thirdMoment.nDevSq;
    }
}

