/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class VectorialCovariance
implements Serializable {
    private static final long serialVersionUID = 4118372414238930270L;
    private final double[] sums;
    private final double[] productsSums;
    private final boolean isBiasCorrected;
    private long n;

    public VectorialCovariance(int n, boolean bl) {
        this.sums = new double[n];
        this.productsSums = new double[n * (n + 1) / 2];
        this.n = 0L;
        this.isBiasCorrected = bl;
    }

    public void increment(double[] dArray) {
        if (dArray.length != this.sums.length) {
            throw new DimensionMismatchException(dArray.length, this.sums.length);
        }
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = i;
            this.sums[n2] = this.sums[n2] + dArray[i];
            for (int j = 0; j <= i; ++j) {
                int n3 = n++;
                this.productsSums[n3] = this.productsSums[n3] + dArray[i] * dArray[j];
            }
        }
        ++this.n;
    }

    public RealMatrix getResult() {
        int n = this.sums.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n);
        if (this.n > 1L) {
            double d = 1.0 / (double)(this.n * (this.isBiasCorrected ? this.n - 1L : this.n));
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double d2 = d * ((double)this.n * this.productsSums[n2++] - this.sums[i] * this.sums[j]);
                    realMatrix.setEntry(i, j, d2);
                    realMatrix.setEntry(j, i, d2);
                }
            }
        }
        return realMatrix;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.n = 0L;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.productsSums, 0.0);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.isBiasCorrected ? 1231 : 1237);
        n2 = 31 * n2 + (int)(this.n ^ this.n >>> 32);
        n2 = 31 * n2 + Arrays.hashCode(this.productsSums);
        n2 = 31 * n2 + Arrays.hashCode(this.sums);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorialCovariance)) {
            return false;
        }
        VectorialCovariance vectorialCovariance = (VectorialCovariance)object;
        if (this.isBiasCorrected != vectorialCovariance.isBiasCorrected) {
            return false;
        }
        if (this.n != vectorialCovariance.n) {
            return false;
        }
        if (!Arrays.equals(this.productsSums, vectorialCovariance.productsSums)) {
            return false;
        }
        return Arrays.equals(this.sums, vectorialCovariance.sums);
    }
}

