/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.rank;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathUtils;

public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -2941995784909003131L;
    private long n;
    private double value;

    public Min() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Min(Min min) {
        Min.copy(min, this);
    }

    public void increment(double d) {
        if (d < this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2)) {
            d = dArray[n];
            for (int i = n; i < n + n2; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                d = d < dArray[i] ? d : dArray[i];
            }
        }
        return d;
    }

    public Min copy() {
        Min min = new Min();
        Min.copy(this, min);
        return min;
    }

    public static void copy(Min min, Min min2) {
        MathUtils.checkNotNull(min);
        MathUtils.checkNotNull(min2);
        min2.setData(min.getDataRef());
        min2.n = min.n;
        min2.value = min.value;
    }
}

