/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class GTest {
    public double g(double[] dArray, long[] lArray) {
        if (dArray.length < 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        if (dArray.length != lArray.length) {
            throw new DimensionMismatchException(dArray.length, lArray.length);
        }
        MathArrays.checkPositive(dArray);
        MathArrays.checkNonNegative(lArray);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            d += dArray[i];
            d2 += (double)lArray[i];
        }
        double d3 = 1.0;
        boolean bl = false;
        if (FastMath.abs(d - d2) > 1.0E-5) {
            d3 = d2 / d;
            bl = true;
        }
        double d4 = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            double d5 = bl ? FastMath.log((double)lArray[i] / (d3 * dArray[i])) : FastMath.log((double)lArray[i] / dArray[i]);
            d4 += (double)lArray[i] * d5;
        }
        return 2.0 * d4;
    }

    public double gTest(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.g(dArray, lArray));
    }

    public double gTestIntrinsic(double[] dArray, long[] lArray) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)dArray.length - 2.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.g(dArray, lArray));
    }

    public boolean gTest(double[] dArray, long[] lArray, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.gTest(dArray, lArray) < d;
    }

    private double entropy(long[][] lArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            for (n = 0; n < lArray[n2].length; ++n) {
                d2 += (double)lArray[n2][n];
            }
        }
        for (n2 = 0; n2 < lArray.length; ++n2) {
            for (n = 0; n < lArray[n2].length; ++n) {
                if (lArray[n2][n] == 0L) continue;
                double d3 = (double)lArray[n2][n] / d2;
                d += d3 * FastMath.log(d3);
            }
        }
        return -d;
    }

    private double entropy(long[] lArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < lArray.length; ++n) {
            d2 += (double)lArray[n];
        }
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] == 0L) continue;
            double d3 = (double)lArray[n] / d2;
            d += d3 * FastMath.log(d3);
        }
        return -d;
    }

    public double gDataSetsComparison(long[] lArray, long[] lArray2) {
        if (lArray.length < 2) {
            throw new DimensionMismatchException(lArray.length, 2);
        }
        if (lArray.length != lArray2.length) {
            throw new DimensionMismatchException(lArray.length, lArray2.length);
        }
        MathArrays.checkNonNegative(lArray);
        MathArrays.checkNonNegative(lArray2);
        long l = 0L;
        long l2 = 0L;
        long[] lArray3 = new long[lArray.length];
        long[][] lArray4 = new long[2][lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L && lArray2[i] == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, i);
            }
            l += lArray[i];
            l2 += lArray2[i];
            lArray3[i] = lArray[i] + lArray2[i];
            lArray4[0][i] = lArray[i];
            lArray4[1][i] = lArray2[i];
        }
        if (l == 0L || l2 == 0L) {
            throw new ZeroException();
        }
        long[] lArray5 = new long[]{l, l2};
        double d = (double)l + (double)l2;
        return 2.0 * d * (this.entropy(lArray5) + this.entropy(lArray3) - this.entropy(lArray4));
    }

    public double rootLogLikelihoodRatio(long l, long l2, long l3, long l4) {
        double d = this.gDataSetsComparison(new long[]{l, l2}, new long[]{l3, l4});
        double d2 = FastMath.sqrt(d);
        if ((double)l / (double)(l + l2) < (double)l3 / (double)(l3 + l4)) {
            d2 = -d2;
        }
        return d2;
    }

    public double gTestDataSetsComparison(long[] lArray, long[] lArray2) {
        ChiSquaredDistribution chiSquaredDistribution = new ChiSquaredDistribution(null, (double)lArray.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.gDataSetsComparison(lArray, lArray2));
    }

    public boolean gTestDataSetsComparison(long[] lArray, long[] lArray2, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.gTestDataSetsComparison(lArray, lArray2) < d;
    }
}

